/*------------------------------------------------------------------------------
 Eisenbahnsteuerung made by: Andreas Lutters / Achim Walder
 
 portions by Ulrich Radig
 
 Kommandointerpreter

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
 GNU General Public License, wie von der Free Software Foundation verffentlicht, 
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
 (nach Ihrer Option) jeder spteren Version. 

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
 Programm erhalten haben. 
 Falls nicht, schreiben Sie an die Free Software Foundation, gct
 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
 
 ################################################################################
 Program uses parts of the above mentioned Software of Ulrich Radig.
 All other code is solely public domain software contributed to the public under the 
 above mentioned GNU licence
 
################################################################################

Beschreibung: https://www.mikrocontroller.net/articles/AVR-GCC-Tutorial
 
------------------------------------------------------------------------------*/

#include "config.h"
#include "cmd.h"
#include <avr/io.h>
#include <util/delay.h>
#include <string.h>
#include <stdlib.h>
#include <avr/eeprom.h>
#include "usart.h"
#include "timer.h"

volatile unsigned int variable[MAX_VAR];

COMMAND_STRUCTUR COMMAND_TABELLE[] = 									// Befehls-Tabelle
	{
	//@ MC-Befehle ----------------------------------------------------------------------------------------
	{"MC_RESET",			set_MC_Reset},								// MC neu starten
	{"MC_INIT",				set_MC_INIT},								// MC-Port A,C,D in Grundstellung
	{"MC_READY",			set_MC_ready},								// MC-Aktiv ?
	{"MC_LED",				set_MC_LED},								// MC-LED Testlauf

	//@ MC Reister setzten ----------------------------------------------------------------------------------
	{"MC_StReg",			set_MC_SteuerRegister},						// MC-SteuerRegister
	{"MC_BM",				set_MC_Betrieb_Modus},						// MC-Betriebs-Modus 0 - 4 
	{"MC_RM",				set_MC_Response_Modus},						// MC-Rckmeldung an
	{"MC_TM",				set_MC_Test_Modus},							// MC-TestModus ?
	{"Bahn_INIT",			set_MC_Bahn_INIT},							// Bahn alle Werte auf 0 
	{"Bahn_AM",				set_MC_Bahn_Automatik_Modus},				// Bahn Automatic-Modus 0 - 4 
	{"Bahn_NS",				set_MC_Bahn_NotStopp},						// Bahn NotStopp

	//@ Test-Modus ----------------------------------------------------------------------------------------
	{"MC_Daten_NEU",		set_MC_Daten_NEU},							// MC-Port-C Grundzustand 
	{"MC_Daten_OUT",		set_MC_Daten_OUT},							// MC-Port-C Output 
	{"MC_Daten_IN",			set_MC_Daten_IN}, 							// MC-Port-D Input 
//	{"MC_Daten_Test",		get_MC_Daten_Test},							// MC-Daten-Test
	{"MC_Port_A_00",		set_MC_Port_A_00},							// MC-Port-A = 00
	{"MC_Port_C_00",		set_MC_Port_C_00},							// MC-Port-C = 00
	{"MC_Port_D_00",		set_MC_Port_D_00},							// MC-Port-D = 00
	{"MC_Port_A_FF",		set_MC_Port_A_FF},							// MC-Port-A = FF
	{"MC_Port_C_FF",		set_MC_Port_C_FF},							// MC-Port-C = FF
	{"MC_Port_A",			set_MC_Port_A},								// MC-Port-A PinNr BitWert = 0/1, analog 1-7 
	{"MC_Port_C",			set_MC_Port_C},								// MC-Port-C PinNr BitWert = 0/1, analog 1-7 
	{"MC_Port_D",			set_MC_Port_D},								// MC-Port-D PinNr BitWert = 0/1, analog 1-7 
//	{"MC_Port_C_Wert",		get_MC_Daten_Test},							// MC-Daten-Test

	//@ Bahn-Befehle ----------------------------------------------------------------------------------------
	{"Bl_Daten",			set_MC_Bahn_Block_Daten}, 					// Bahn Block-Daten = Daten fr einen Blockabschnitt
	{"St_Status",			set_MC_Bahn_Strecken_Status},				// Bahn Strecken-Status-Register setzen 
	{"Bl_Status",			set_MC_Bahn_Block_Status},					// Bahn Block-Status-Register 0 - 1 setzen
	{"Bl_Aktiv",			set_MC_Bahn_Block_Aktiv},					// Bahn Block-Aktiv-Register 0 - 2 setzen
	{"Bl_Delay",			set_MC_Bahn_Block_Delay},					// Bahn alle Block-Strecken-Delay schalten  1..32
	{"Bl_FS_max",			set_MC_Bahn_Block_FS_max},					// Bahn alle Block-Fahrstufe max   1..32
	{"Bl_FS_min",			set_MC_Bahn_Block_FS_min},					// Bahn alle Block-Fahrstufe min  1..32
	{"Bl_FS_soll",			set_MC_Bahn_Block_FS_soll},					// Bahn alle Block-Fahrstufe soll  1..32
	{"Bl_FS_Delay1",		set_MC_Bahn_Block_FS_Delay1},				// Bahn alle Block-Fahrstufe Delay1 schalten  1..32
	{"Bl_FS_Delay2",		set_MC_Bahn_Block_FS_Delay2},				// Bahn alle Block-Fahrstufe Delay2 schalten  1..32

	//@ Weichen-Befehle ----------------------------------------------------------------------------------------
	{"Weichen",				set_MC_Bahn_Weichen},		  				// Bahn Weiche schalten [x] [y]
	{"Weichen_Reset",		set_MC_Bahn_Weichen_Reset},					// Bahn Weichen Reset
	{"Weichen_Delay",		set_MC_Bahn_Weichen_Delay},  				// Bahn Weiche Delay*


	//@ MC Rckmelungen an PC -----------------------------------------------------------------------------
	{"HELP",				show_help},									// MC-Befehlsliste anzeigen
	{"?",					show_help},									// MC-Befehlsliste anzeigen
	{"show_MC_StReg",		show_MC_SteuerRegister},					// MC-SteuerRegister
	{"show_Bahn_REG",		show_MC_Bahn_Register},						// MC-Register anzeigen
	{"show_Bahn_Bl_FSist",	show_MC_Bahn_Block_FSist},					// Bahn Block FS ist
	{"Bahn_St_BM",			get_MC_Bahn_Strecken_Beleg},				// Bahn Beleg-Messung
	{"Bahn_St_KM",			get_MC_Bahn_Strecken_Kurzschluss},			// Bahn Kurzschluss-Messung
//	{"Bahn_Bl_Test",		get_MC_Bahn_Block_Test},					// Bahn Beleg-TestMessung

	{NULL,NULL} 
	};

//####################################################################################################mc_HELP

//@@ MC-Befehlsliste

PROGMEM const char helptext[] = 
	{
	"\r\n"
	"==== Microcontroler Steuerung ================================================\r\n"
	"MC_RESET           - setzen MC-Reset\r\n"
	"MC_INIT            - setzen MC Grundeinstellung\r\n"
	"MC_Ready           - setzen MC betriebsbereit ?\r\n"
	"MC_LED             - setzen MC LED-Test\r\n"
	"MC_BM 0..5         - setzen MC-Betrieb-Modus 0 - 5\r\n"
	"MC_TM x            - setzen MC-Test-Modus [0..1]\r\n"
	"MC_RM x            - setzen MC-Rckmeldung [0..1]\r\n"

	"===== Test-Modus =============================================================\r\n"
	"MC_StReg           - setzen MC-SteuerRegister\r\n" 
	"MC_Daten_OUT       - setzen MC-Port-C Output\r\n" 
	"MC_Daten_IN        - setzen MC-Port-D Input\r\n" 
	"MC_Daten_Test      - setzen MC-Port-C Wert an PC senden\r\n"
	"MC_Port_A_00       - setzen MC-Port-A = 00\r\n"
	"MC_Port_C_00       - setzen MC-Port-C = 00\r\n"
	"MC_Port_D_00       - setzen MC-Port-D = 00\r\n"
	"MC_Port_A_FF       - setzen MC-Port-A = FF\r\n"
	"MC_Port_C_FF       - setzen MC-Port-C = FF\r\n"
	"MC_Port_A x        - setzen MC-Port-A PinNr BitWert = 0/1, analog fr A0 -- A7\r\n"
	"MC_Port_C x        - setzen MC-Port-C PinNr BitWert = 0/1, analog fr C0 -- C7\r\n" 
	"MC_Port_D x        - setzen MC-Port-D PinNr BitWert = 0/1, analog fr D2 -- D7\r\n" 

	"==== Weichensteuerung (BM3) =====================================================\r\n"
	"Weichen            - setzte Weichen [x] [y]\r\n"
	"Weichen_Delay      - setze Weichen-Delay\r\n"

	"==== Bahnsteuerung (BM4) =====================================================\r\n"
	"Bahn_INIT          - setzen Bahn alle Werte auf 0\r\n" 
	"Bahn_NS            - setzen Bahn NotStopp\r\n"
	"Bahn_AM            - setzen Bahn AutmatikModus 0 - 4\r\n"
	"===== Block- und Streckendaten ===============================================\r\n"
	"Bl_Daten           - setzen Bahn Block-Daten\r\n"
	"Bl_Status x        - setzen Bahn Block-Status-Register 0 - 1 setzen\r\n"
	"Bl_Aktiv x         - setzen Bahn Block-Aktiv-Register 0 - 2 setzen\r\n"
	"Bl_Delay xx        - setzen Bahn Block-Delay (32 Werte 0 - 99)\r\n"
	"Bl_FS_max xx       - setzen Bahn Block FS-max (32 Werte 0 - 80)\r\n"
	"Bl_FS_min xx       - setzen Bahn Block FS-min (32 Werte 0 - 80)\r\n"
	"Bl_FS_soll xx      - setzen Bahn Block FS-soll (32 Werte 0 -80)\r\n"
	"Bl_FS_Delay1 xx    - setzen Bahn Block Delay1 = beschleinigen (32 Werte 0 - 99)\r\n"
	"Bl_FS_Delay2 xx     - setzen Bahn Block Delay2 = bremsen (32 Werte 0 - 99)\r\n"
	"Bl_FSist           - setzen Block FS ist\r\n"
	"St_Status          - setzen Bahn Strecken-Status-Register setzen\r\n" 
	"St_BM              - setzen Bahn Block Beleg-Messung\r\n"
	"St_KM              - setzen Bahn Block Kurzschluss-Messung\r\n"
	"BR                 - setzen Bahn Register\r\n"
	
	"===== MC Rckmeldungen =======================================================\r\n"
	"HELP               - Rckmeldung MC-Hilfe-Liste\r\n"
	"?                  - Rckmeldung MC-Hilfe-Liste\r\n"
	"show_MC_StReg      - Rckmeldung MC-SteuerRegister\r\n"
	"show_Bahn_REG      - Rckmeldung MC-Bahn_Register\r\n"
	"show_Bahn_Bl_FSist - Rckmeldung MC-Bahn Block FS ist\r\n"
	"Bahn_St_BM         - Rckmeldung MC-Bahn Beleg-Messung\r\n"
	"Bahn_St_KM         - Rckmeldung MC-Bahn Kurzschluss-Messung\r\n"
//	{"Bahn_Bl_Test",     get_MC_Bahn_Block_Test},				// Bahn Beleg-TestMessung

	
	};

//###################################################################################################################
//###################################################################################################################
//
// MC Hilfs-Routinen
//
//###################################################################################################################
//###################################################################################################################

//###################################################################################################################
//	Kommando auswerten - Werte die Kommandotabelle COMMAND_STRUCTUR COMMAND_TABELLE aus
//--------------------------------------------------------------------------------------------------------------------
unsigned char extract_cmd (char *string_pointer)
	{
	//Stringzeiger;
	char 			*string_pointer_tmp;
	unsigned char 	cmd_index = 0;
	unsigned char 	VarNr = 1;
//	unsigned 		CheckSummeExtrakt = 0;

	// alle Variablen[..] = 0 -- A.Walder 6-6-2017
	for (VarNr = 1; VarNr < MAX_VAR; VarNr++)
		variable[VarNr] = 0;

	string_pointer_tmp = strsep(&string_pointer," "); 
	//Kommando in Tabelle suchen
	while(strcasecmp(COMMAND_TABELLE[cmd_index].cmd,string_pointer_tmp))
		{
		if (COMMAND_TABELLE[++cmd_index].cmd == 0) 			//Abruch Whileschleife und Unterprogramm verlassen 
			return(0);
		}
	//Variablen finden und auswerten
	for (VarNr = 1; VarNr < MAX_VAR; VarNr++)
		{ 
        string_pointer_tmp = strsep(&string_pointer,"., ");  
		variable[VarNr] = strtol(string_pointer_tmp,NULL,0);
		}

/*
	// MC-Rckmeldung -- Anzeige der Varibalen (Walder) -----------------------------
	if (MC_Responce_Modus == 1)
		{
		CheckSummeExtrakt = 0;
		usart_write("Extact_Command ");
		for (VarNr = 1; VarNr < MAX_VAR; VarNr++)
			{
			usart_write("%3i ",variable[VarNr]);
			if ((VarNr % 8 == 0) | (VarNr % 16 == 0) | (VarNr % 24 == 0) | (VarNr % 32 == 0))
				{usart_write(".");};
			CheckSummeExtrakt = CheckSummeExtrakt + variable[VarNr];
			};
		usart_write("  MC-CS = %i \r\n", (CheckSummeExtrakt / 2));
		}
	//--------------------------------------------------------------------
*/
    //Kommando ausfhren
	COMMAND_TABELLE[cmd_index].fp();

	return(1); 
	}
	
//###################################################################################################################
//  Pause
//--------------------------------------------------------------------------------------------------------------------
void long_delay(int ms)
	{
	if (MC_Betrieb_Modus != 4)
		for(; ms > 0; ms--)
			_delay_ms(1);
	}



//###################################################################################################################
//###################################################################################################################
//
// MC Start
//
//###################################################################################################################
//###################################################################################################################

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@ RESET = MC Reset ausfhren
//@ PC ==> Reset
//@--------------------------------------------------------------------------------------------------------------------
void set_MC_Reset(void)
	{
	usart_write("\r\n");
	usart_write("-----------------\r\n");
	usart_write("MC-Reset !!\r\n");
	usart_write("-----------------\r\n\r\n");
	RESET(); 
	asm("nop");																		// !!!! mindestens 4 * NOP
	asm("nop");
	asm("nop");
	asm("nop");
	asm("nop");
	asm("nop");
	
	set_MC_INIT();																// MC-INIT ==>  Werte in Grundstellung
	}
	
//@###################################################################################################################
//@ MC-INIT ==>  Werte in Grundstellung
//@ MC-Port A,C,D = output in Grundstellung 
//@--------------------------------------------------------------------------------------------------------------------
void set_MC_INIT()
	{
	// MC Einstelungen ---------------------------------------------------------------------------
	MC_Betrieb_Modus = 0; 											// MC-BetriebsModus = 0
	MC_Responce_Modus = 1;											// MC-RckmeldungModus = 0 keine Rckmeldung
	MC_Test_Modus = 0;												// MC-TestModus = 0

	// MC1 Bahn-Einstellungen ------------------------------------------------------------------------
	Bahn_Automatik_Modus = 0;										// MC-AutomatikModus = 0

	// MC2 Weichen-Einstellungen ------------------------------------------------------------------------------
	Weichen_Delay = 1;												// Delay fr Weichen-Rckstellung
	Weichen_TimerDelay = 1;											// Delay fr Weichen-Rckstellung
	Weichen_MC_TimerDelay = 1;										// Delay fr Weichen-Rckstellung
	Weichen_NEU = 0;												// Flag, wenn neue Weichenstellung dann 1

	//@ MC-Register in Grundstellung =======================================================================================

	//@ MC-Port-D Steuerung -----------------------------------------------
	DDRD = 0xFF;													// MC-Port-D ==>Steuerung Output
	asm("nop");
	PORTD = 0b11011000;												// MC-Port-D => 	[11_1.1___]
																	// MC-Port-D7 => 	[1___.____] => Interface 74LS154 Encoder kein CS fr Blockplatine
																	// MC-Port-D6 =>	[_1__.____] => Interface 74LS245 ??
																	// MC-Port-D4 =>	[___1.____] => Interface 74LS245 Daten nicht aktiv
																	// MC-Port-D3 =>	[____.1___] => Interface 74LS245 Daten output
	asm("nop");

	//@ MC-Port-A Adressen -----------------------------------------------------
	DDRA = 0xFF;													// MC-Port-A Adressen Output
	asm("nop");
	PORTA = 0x00;													// MC-Port-A Adressen = [00]
	asm("nop");

	//@ MC-Port-C Daten -----------------------------------------------------
	DDRC = 0xFF;													// MC-Port-C Control Output
	asm("nop");
	PORTC = 0x00;													// MC-Port-C Daten = [00]
	asm("nop");

	// MC-Rckmeldung --- MC Steuer-Register anzeigen ----------------------------------
	usart_write("\r\n");
	usart_write("----------------------------------------------------------------------\r\n");
	usart_write("MC-INIT !!\r\n");
	usart_write("MC-Eisenbahnprogramm (c) Achim Walder & Andreas Lutters ==> 2020-11-25\r\n");
	usart_write("----------------------------------------------------------------------\r\n"); 
	usart_write("MC-Port-D = [11_1.1___]\r\n");
	usart_write("MC-Port-A = [0000.0000]\r\n");
	usart_write("MC-Port-C = [0000.0000]\r\n");
	usart_write("MC-Register --> BM = %1i, NS = %1i, RM = %1i, X, X, AM-HS = %1i, AM-SB = %1i, AM-NS = %1i, AM-GB = %1i, AM-St = %1i, X, X \r\n",
	MC_Betrieb_Modus, MC_NotStopp, MC_Responce_Modus, Bahn_Automatik_HS_Modus, Bahn_Automatik_SB_Modus, Bahn_Automatik_NS_Modus, Bahn_Automatik_GB_Modus, Bahn_Automatik_St_Modus);
	}
	
//###################################################################################################################
// MC-OK - ist MC betriebsbereit ? 															
// PC ==> MC
//--------------------------------------------------------------------------------------------------------------------
void set_MC_ready(void)
	{
	usart_write("\r\n");
	usart_write("---------------\r\n");
	usart_write("MC-Ready !!\r\n");
	usart_write("---------------\r\n\r\n");
	return;
	}


//###################################################################################################################
//###################################################################################################################
//
//     MC Steuerung
//
//###################################################################################################################
//###################################################################################################################


//###################################################################################################################
// MC SteuerRegister setzen 
//--------------------------------------------------------------------------------------------------------------------
void set_MC_SteuerRegister(void)
	{
	MC_Betrieb_Modus					= variable[1];
	MC_NotStopp							= variable[2];
	MC_Responce_Modus					= variable[3];
	Bahn_Automatik_HS_Modus 			= variable[6];
	Bahn_Automatik_SB_Modus				= variable[7];
	Bahn_Automatik_NS_Modus				= variable[8];
	Bahn_Automatik_GB_Modus				= variable[9];
	Bahn_Automatik_St_Modus				= variable[10];
	
	// // Startwert setzten ! ----------------------
	if (MC_Betrieb_Modus == 4)
		{ 
		zeile = 1;
		spalte = 1;
		Peek = 1;
		};       

	// MC-Rckmeldung --- MC Steuer-Register anzeigen ----------------------------------
	usart_write("MC-Register --> BM = %1i, NS = %1i, RM = %1i, X, X, AM-HS = %1i, AM-SB = %1i, AM-NS = %1i, AM-GB = %1i, AM-St = %1i, X, X \r\n", 
	MC_Betrieb_Modus, MC_NotStopp, MC_Responce_Modus, Bahn_Automatik_HS_Modus, Bahn_Automatik_SB_Modus, Bahn_Automatik_NS_Modus, Bahn_Automatik_GB_Modus, Bahn_Automatik_St_Modus);
	return;
	}


//###################################################################################################################################
// MC-Betrieb-Modus einstellen			   										21-12-2013
// PC ==> BM 0, BM 1, BM 2, BM 3, BM 4
//--------------------------------------------------------------------------------------------------------------------
void set_MC_Betrieb_Modus(void)
	{
	set_MC_Bahn_INIT();										// Bahn-INIT MC-Betriebsmodus = 0, Bahn-Autoamtik-Modus = 0
	MC_Betrieb_Modus = variable[1];

	switch (MC_Betrieb_Modus)   								
		{
		case 0 : usart_write("MC-Betrieb = 0\r\n");break;
		case 1 : usart_write("MC-Betrieb = 1\r\n");break;
		case 2 : usart_write("MC-Betrieb = 2\r\n");break;
		case 3 : usart_write("MC-Betrieb = 3\r\n");break;
		case 4 : usart_write("MC-Betrieb = 4\r\n");break;
		};   

	// // Startwert setzten ! ----------------------
	if (MC_Betrieb_Modus == 4)   		 						
		{ 
		zeile = 1;
		spalte = 1;
		Peek = 1;
		};      					        

	// MC-Rckmeldung --- MC Steuer-Register anzeigen ----------------------------------
	usart_write("MC-Register --> BM = %1i, NS = %1i, RM = %1i, X, X, AM-HS = %1i, AM-SB = %1i, AM-NS = %1i, AM-GB = %1i, AM-St = %1i, X, X \r\n", 
	MC_Betrieb_Modus, MC_NotStopp, MC_Responce_Modus, Bahn_Automatik_HS_Modus, Bahn_Automatik_SB_Modus, Bahn_Automatik_NS_Modus, Bahn_Automatik_GB_Modus, Bahn_Automatik_St_Modus);
	return;										
	}

//###################################################################################################################
// MC-Rckmeldungen																			18. Mrz 2012
// PC ==> RC 0 oder RC 1
//--------------------------------------------------------------------------------------------------------------------
void set_MC_Response_Modus(void)
	{
	MC_Responce_Modus = variable[1];
	if (MC_Responce_Modus == 0)
		{usart_write("MC-Responce-Modus = aus\r\n");}
	else
		{usart_write("MC-Responce-Modus = ein\r\n");}

	// MC-Rckmeldung --- MC Steuer-Register anzeigen ----------------------------------
	usart_write("MC-Register --> BM = %1i, NS = %1i, RM = %1i, X, X, AM-HS = %1i, AM-SB = %1i, AM-NS = %1i, AM-GB = %1i, AM-St = %1i, X, X \r\n", 
	MC_Betrieb_Modus, MC_NotStopp, MC_Responce_Modus, Bahn_Automatik_HS_Modus, Bahn_Automatik_SB_Modus, Bahn_Automatik_NS_Modus, Bahn_Automatik_GB_Modus, Bahn_Automatik_St_Modus);
	return;
	}

//###################################################################################################################
// MC-Test
// Test Rckmeldungen
//--------------------------------------------------------------------------------------------------------------------
void set_MC_Test_Modus(void)
	{
	MC_Test_Modus = variable[1];
	if (MC_Test_Modus == 0)
		{usart_write("MC-Test-Modus = aus\r\n");}
	else
		{usart_write("MC-Test-Modus = ein\r\n");}

	// MC-Rckmeldung --- MC Steuer-Register anzeigen ----------------------------------
	usart_write("MC-Register --> BM = %1i, NS = %1i, RM = %1i, X, X, AM-HS = %1i, AM-SB = %1i, AM-NS = %1i, AM-GB = %1i, AM-St = %1i, X, X \r\n", 
	MC_Betrieb_Modus, MC_NotStopp, MC_Responce_Modus, Bahn_Automatik_HS_Modus, Bahn_Automatik_SB_Modus, Bahn_Automatik_NS_Modus, Bahn_Automatik_GB_Modus, Bahn_Automatik_St_Modus);
	return;
	}


//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//
// Textroutinen fr Platinentest
//
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@


//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@ HELP = Hilfetext Ausgabe
//@ PC ==> Help oder ?
void show_help (void)
	{
	#if HELPTEXT
		unsigned char data;
		PGM_P helptest_pointer = helptext;
		do
			{
			data = pgm_read_byte(helptest_pointer++);
			usart_write("%c",data);
			}
		while(data != 0);
	#endif
	}


//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@ MC LED-Test - alle LEDs einmal ein und aus 								- 10. November 2012
void set_MC_LED(void)
	{
	unsigned int Pin;
//    set_MC_Bahn_NotStopp();								// Bahn-Notstopp
	MC_Responce_Modus = 1; 									// MC-Rckmeldung ein 
	MC_Betrieb_Modus = 1;   								// Muss gesetzt sein, damit es berhaupt eine Reaktion gibt!
	// MC-Rckmeldung -------------------------------------
	usart_write("\r\n");
	usart_write("---------------\r\n");
	usart_write("MC-LED-Test\r\n"); 
	usart_write("---------------\r\n\r\n");

	// MC-Port-D Steuerleitungen -------------------------------------------------
	for( Pin = 2; Pin < 8; Pin++)
		{
		PORTD |= _BV(Pin);
		long_delay(10);
		}
	for( Pin = 2; Pin < 8; Pin++)
		{
		PORTD &= 255-_BV(Pin);
		long_delay(10);
		}
	// MC-Port-D in Grundstellung
	DDRD = 0xFF;																	// MC-Port-D ==>Steuerung Output
	asm("nop");
	PORTD = 0b11011000;														// MC-Port-D => [11_1.1___]

	// MC-Port-C Datenleitungen ---------------------------------------------------
	for( Pin = 0; Pin < 8; Pin++)
		{
		PORTC |= _BV(Pin);
		long_delay(10);
		}
	for( Pin = 0; Pin < 8; Pin++)
		{
		PORTC &= 255-_BV(Pin);
		long_delay(10);
		}

	// MC-Port-A Datenleitungen ---------------------------------------------------
	for( Pin = 0; Pin < 8; Pin++)
		{
		PORTA |= _BV(Pin);
		long_delay(10);
		}
	for( Pin = 0; Pin < 8; Pin++)
		{
		PORTA &= 255-_BV(Pin);
		long_delay(10);
		}

	set_MC_INIT();											// MC in Grundstellung Port A,C,D = output
	}

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@
//@ MC Testprogramme
//@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@ setzte MC-Daten NEU
void set_MC_Daten_NEU(void)
	{
	if (MC_Betrieb_Modus < 3)
		{
		PORTD |= _BV(7);													// MC-Port-D7 auf 1 => Encoder-74LS154 nicht aktiv, kein CS
		PORTD |= _BV(4);													// MC-Port-D3 auf 1 => Interface-74LS245 nicht aktiv
		PORTD |= _BV(3);													// MC-Port-D3 auf 1 => Interface-74LS245 Daten output
		DDRC = 0xFF;														// MC-Port-C output
		usart_write("MC-Daten-Grundzustand\r\n");
		}
	else
		usart_write("==> ERROR !! BM > 3 \r\n");
	}
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@ setzte MC-Daten Output
void set_MC_Daten_OUT(void)
	{
	if (MC_Betrieb_Modus < 3)
		{
		PORTD |= _BV(7);													// MC-Port-D7 auf 1 => Encoder-74LS154 nicht aktiv, kein CS
		PORTD |= _BV(3);													// MC-Port-D3 auf 1 => Interface-74LS245 Daten output
		PORTD &= 255-_BV(4);												// MC-Port-D4 auf 0 => Interface-74LS245 Daten aktiv
		DDRC = 0xFF;														// MC-Port-C output
		usart_write("MC-Daten-Output\r\n");	
		}
	else
		usart_write("==> ERROR !! BM > 3 \r\n");
	}
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@ setzte MC-Daten Input
void set_MC_Daten_IN(void)
	{
	if (MC_Betrieb_Modus < 3)
		{
		PORTD |= _BV(7);													// MC-D7 auf 1 => 74LS154 Encoder nicht aktiv, kein CS
		DDRC = 0x00; 														// MC-Port-C (Daten) als Eingang 
		PORTC = 0xFF; 														// MC-Port-C (Daten) als Eingang - with pull-ups enabled
		PORTD &= 255-_BV(3);												// MC-D3 auf 0 => 74LS245 Interface-Daten input
		PORTD &= 255-_BV(4);												// MC-D4 auf 0 => 74LS245 Interface-Daten aktiv
		usart_write("MC-Daten-Input\r\n");	
		}
	else
		usart_write("==> ERROR !! BM > 3 \r\n");
	}
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@ get MC-Daten Test
void get_MC_Daten_Test(void)
	{
	unsigned int Port_C_Wert;
	if (MC_Betrieb_Modus < 3)
		{
		Port_C_Wert = PINC;													// Einlesen von MC-Port-C
		usart_write("MC-Daten = %3i \r\n",Port_C_Wert);						// sendet MC-Wert an PC
		}
	else
		usart_write("==> ERROR !! BM > 3 \r\n");
	}
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@ set MC-Port-A 
void set_MC_Port_A(void)
	{
	unsigned char APinNr;
	unsigned char BitWert;
	APinNr = variable[1];
	BitWert = variable[2];
	if (MC_Betrieb_Modus < 3)
		{
		if (APinNr < 8)
			{
			if (BitWert == 1) 
				{
				DDRA = 0xFF; 
				PORTA |= _BV(APinNr);										// ein MC-Port-A x = 1
				usart_write("MC-Port-A %1i = [1]\r\n", APinNr);
				}
			else
				{
				DDRA = 0xFF; 
				PORTA &= 255 - _BV(APinNr);									// ein MC-Port-A x = 0
				usart_write("MC-Port-A %1i = [0]\r\n", APinNr);
				}
			}	
		}
	else
		{
		usart_write("==> ERROR !! BM > 3 \r\n");
		}
	}
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@ set MC-Port-C
void set_MC_Port_C(void)
	{
	unsigned char CPinNr;
	unsigned char BitWert;
	CPinNr = variable[1];
	BitWert = variable[2];
	if (MC_Betrieb_Modus < 3)
		{
		if (CPinNr < 8)
			{
			if (BitWert == 1)
				{
				DDRC = 0xFF; 
				PORTC |= _BV(CPinNr);											// MC-Port-C x = 1
				usart_write("MC-Port-C %1i = [1]\r\n", CPinNr);
				}
			else
				{
				DDRC = 0xFF; 
				PORTC  &= 255 - _BV(CPinNr);										// MC-Port-C x = 0
				usart_write("MC-Port-C %1i = [0]\r\n", CPinNr);
				}
			}	
		}	
	else
		usart_write("==> ERROR !! BM > 3 \r\n");
	}
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@ set MC-Port-D (PIN-D0 und PIN-D1 werden nicht geschaltet)
void set_MC_Port_D(void)
	{
	unsigned char DPinNr;
	unsigned char BitWert;
	DPinNr = variable[1];
	BitWert = variable[2];
	if (MC_Betrieb_Modus < 3)
		{
		if ((DPinNr > 1) &  (DPinNr < 8))
			{
			if (BitWert == 1)
				{
				DDRD = 0xFF; 
				PORTD |= _BV(DPinNr);											// MC-Port-D x = 1
				usart_write("MC-Port-D %1i = [1]\r\n", DPinNr);
				}
			else
				{
				DDRD = 0xFF; 
				PORTD  &= 255 - _BV(DPinNr);										// MC-Port-D x = 0
				usart_write("MC-Port-D %1i = [0]\r\n", DPinNr);
				}
			}	
		}
	else
		usart_write("==> ERROR !! BM > 3 \r\n");
	}
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@ setzte MC-Port-A auf 00
void set_MC_Port_A_00(void)
	{
	if (MC_Betrieb_Modus < 3)
		{
		DDRA = 0xFF; 
		PORTA = 0x00; 														// MC-Port-A = 00
		usart_write("MC-Port-A = [00] \r\n");
		}
	else
		usart_write("==> ERROR !! BM > 3 \r\n");
	}
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@ setzte MC-Port-C auf 00
void set_MC_Port_C_00(void)
	{
	if (MC_Betrieb_Modus < 3)
		{
		DDRC = 0xFF; 
		PORTC = 0x00; 														// MC-Port-C = 00
		usart_write("MC-Port-C = [00] \r\n");
		}
	else
		usart_write("==> ERROR !! BM > 3 \r\n");
	}
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@ setzte MC-Port-D auf 00
void set_MC_Port_D_00(void)
	{
	if (MC_Betrieb_Modus < 3)
		{
		DDRD = 0xFF; 
		PORTD = 0x00; 														// MC-Port-D = 00
		usart_write("MC-Port-D = [00] \r\n");	
		}
	else
		usart_write("==> ERROR !! BM > 3 \r\n");
	}
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@ setzte MC-Port-A auf FF
void set_MC_Port_A_FF(void)
	{
	if (MC_Betrieb_Modus < 3)
		{
		DDRA = 0xFF; 
		PORTA = 0xFF; 														// MC-Port-A = FF
		usart_write("MC-Port-A = [FF] \r\n");
		}
	else
		usart_write("==> ERROR !! BM > 3 \r\n");
	}
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@ setzte MC-Port-C auf FF
void set_MC_Port_C_FF(void)
	{
	if (MC_Betrieb_Modus < 3)
		{
		DDRC = 0xFF; 
		PORTC = 0xFF; 														// MC-Port-C = FF
		usart_write("MC-Port-C = [FF] \r\n");
		}
	else
		usart_write("==> ERROR !! BM > 3 \r\n");
	}
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@ setzte MC-Port-A auf xx
void set_register_Port_A(void)
	{
	unsigned int WertA;
	WertA = variable[1];
	if (MC_Betrieb_Modus < 3)
		{
		usart_write("MC-Port-A = [%2i]\r\n",WertA);
		DDRA &= 0xFF;
		PORTA = WertA; 
		} 
	else
		usart_write("==> ERROR !! BM > 3 \r\n");
	}
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@ setzte MC-Port-C auf xx
void set_register_Port_C(void)
	{
	unsigned int WertC;
	WertC = variable[1];
	if (MC_Betrieb_Modus < 3)
		{
		usart_write("MC-Port-C = [%2i]\r\n",WertC);
		DDRC &= 0xFF;
		PORTC = WertC; 
		} 
	else
		usart_write("==> ERROR !! BM > 3 \r\n");
	}
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@ setzte MC-Port-D auf xx
void set_register_Port_D(void)
	{
	unsigned int WertD;
	WertD = variable[1];
	if (MC_Betrieb_Modus < 3)
		{
		usart_write("MC-Port-D = [%2i]\r\n",WertD);
		DDRD &= 0xFF;
	  PORTD = WertD; 
		} 
	else
		usart_write("==> ERROR !! BM > 3 \r\n");
	}

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//
// Bahnbetrieb (BM = 4)
//
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@


//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// MC-SteuerRegister anzeigen
void show_MC_SteuerRegister(void)
	{
	// MC-Rckmeldung --- MC Steuer-Register anzeigen ----------------------------------
	usart_write("MC-Register --> BM = %1i, NS = %1i, RM = %1i, X, X, AM-HS = %1i, AM-SB = %1i, AM-NS = %1i, AM-GB = %1i, AM-St = %1i, X, X \r\n", 
			MC_Betrieb_Modus, MC_NotStopp, MC_Responce_Modus, Bahn_Automatik_HS_Modus, Bahn_Automatik_SB_Modus, Bahn_Automatik_NS_Modus, 
			Bahn_Automatik_GB_Modus, Bahn_Automatik_St_Modus);
	}
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// MC-Register anzeigen
void show_MC_Bahn_Register(void)
	{
	unsigned char TT;  // interner Zhler

	// Steuer-Register ----------------------------------
	usart_write("\r\n");
	// MC-Rckmeldung --- MC Steuer-Register anzeigen ----------------------------------
	usart_write("MC-Register --> BM = %1i, NS = %1i, RM = %1i, X, X, AM-HS = %1i, AM-SB = %1i, AM-NS = %1i, AM-GB = %1i, AM-St = %1i, X, X \r\n", 
	MC_Betrieb_Modus, MC_NotStopp, MC_Responce_Modus, Bahn_Automatik_HS_Modus, Bahn_Automatik_SB_Modus, Bahn_Automatik_NS_Modus, Bahn_Automatik_GB_Modus, Bahn_Automatik_St_Modus);
	// Strecken-Status-Register ----------------------------------
	usart_write("=> St-Status I..");
	for (TT = 1; TT <= 16; TT++)
		{
		usart_write("%3i ",Strecken_Status_Register[TT]);
		if ((TT % 8) == 0)
		  {usart_write(" ");};
		};
	usart_write("\r\n");
	usart_write("St-Status II.");
	for (TT = 17; TT <= 32; TT++)
		{
		usart_write("%3i ",Strecken_Status_Register[TT]);
		if ((TT % 24) == 0)
		  {usart_write(" ");};
		};
	usart_write("\r\n");
	// Block Nummer ----------------------------------
	usart_write("Bl-Nr........ 1  2  3  4  5  6  7  8   9 10 11 12 13 14 15 16  17 18 19 20 21 22 23 24  25 26 27 28 29 30 31 32 \r\n");
	// Block-Status-Register ----------------------------------
	usart_write("Bl-Status....");
	for (TT = 1; TT < 33; TT++)
		{
		usart_write(" %1i ",Block_Status_Register[TT]);
		if (((TT % 8) == 0) && (TT < 32))
		  {usart_write(" ");};
		};
	usart_write("\r\n");
	// Block-Aktiv-Register ----------------------------------
	usart_write("Bl-Aktiv.....");
	for (TT = 1; TT < 33; TT++)
		{
		usart_write(" %1i ",Block_Aktiv_Register[TT]);
		if (((TT % 8) == 0) && (TT < 32))
		  {usart_write(" ");};
		};
	usart_write("\r\n");
	// Block-Delay-Register ----------------------------------
	usart_write("Bl-Delay.....");
	for (TT = 1; TT < 33; TT++)
		{
		usart_write("%2i ",Block_Delay_Register[TT]);
		if (((TT % 8) == 0) && (TT < 32))
		  {usart_write(" ");};
		};
	usart_write("\r\n");
	// Block-FS-max-Register ----------------------------------
	usart_write("Bl-FS-max....");
	for (TT = 1; TT < 33; TT++)
		{
		usart_write("%2i ",Block_FS_max_Register[TT]);
		if (((TT % 8) == 0) && (TT < 32))
		  {usart_write(" ");};
		};
	usart_write("\r\n");
	// Block-FS-min-Register ----------------------------------
	usart_write("Bl-FS-min....");
	for (TT = 1; TT < 33; TT++)
		{
		usart_write("%2i ",Block_FS_min_Register[TT]);
		if (((TT % 8) == 0) && (TT < 32))
		  {usart_write(" ");};
		};
	usart_write("\r\n");
	// Block-FS-Delay1-Register ----------------------------------
	usart_write("Bl-FS-Delay1.");
	for (TT = 1; TT < 33; TT++)
		{
		usart_write("%2i ",Block_FS_Delay1_Register[TT]);
		if (((TT % 8) == 0) && (TT < 32))
		  {usart_write(" ");};
		};
	usart_write("\r\n");
	// Block-FS-Delay2-Register ----------------------------------
	usart_write("Bl-FS-Delay2.");
	for (TT = 1; TT < 33; TT++)
		{
		usart_write("%2i ",Block_FS_Delay2_Register[TT]);
		if (((TT % 8) == 0) && (TT < 32))
		  {usart_write(" ");};
		};
	usart_write("\r\n");
	// Block-FS-soll-Register ----------------------------------
	usart_write("Bl-FS-soll...");
	for (TT = 1; TT < 33; TT++)
		{
		usart_write("%2i ",Block_FS_soll_Register[TT]);
		if (((TT % 8) == 0) && (TT < 32))
		  {usart_write(" ");};
		};
	usart_write("\r\n");
	// Block-FS-ist-Register ----------------------------------
	usart_write("Bl-FS-T-ist..");
	for (TT = 1; TT < 33; TT++)
		{
		usart_write("%2i ",Timer_Block_FS_ist_Register[TT]);
		if (((TT % 8) == 0) && (TT < 32))
		  {usart_write(" ");};
		};
	usart_write("\r\n");
	}

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// Bahn Block FS ist Register senden
void show_MC_Bahn_Block_FSist(void)
	{
	unsigned char TT;  // interner Zhler

	usart_write("Bl-Nr........ 1  2  3  4  5  6  7  8   9 10 11 12 13 14 15 16  17 18 19 20 21 22 23 24  25 26 27 28 29 30 31 32 \r\n");
	usart_write("Bl-FS-T-ist..");
	for (TT = 1; TT < 33; TT++)
		{
		usart_write("%2i ",Timer_Block_FS_ist_Register[TT]);
		if (((TT % 8) == 0) && (TT < 32))
		  {usart_write(" ");};
		};
	usart_write("\r\n");
	}






//###################################################################################################################
//###################################################################################################################
//
// Bahn-Routinen
//
// diese Routinen laufen nur im BM 0
//
//###################################################################################################################
//###################################################################################################################


//###################################################################################################################################
// AM = Automatic-Modus einstellen			   										21-12-2013
// PC ==> AM 0, AM 1, AM 2, AM 4
//--------------------------------------------------------------------------------------------------------------------
void set_MC_Bahn_Automatik_Modus(void)
	{
	Bahn_Automatik_Modus = variable[1];
	switch (Bahn_Automatik_Modus)
		{
		case 0 : usart_write("Bahn-Automatik = 0\r\n");break;
		case 1 : usart_write("Bahn-Automatik = 1\r\n");break;
		case 2 : usart_write("Bahn-Automatik = 2\r\n");break;
		case 3 : usart_write("Bahn-Automatik = 3\r\n");break;
		case 4 : usart_write("Bahn-Automatik = 4\r\n");break;
		case 5 : usart_write("Bahn-Automatik = 5\r\n");break;
		}	
	// Steuer-Register Anzeigen ----------------------------------
	// MC-Rckmeldung --- MC Steuer-Register anzeigen ----------------------------------
	usart_write("MC-Register --> BM = %1i, NS = %1i, RM = %1i, X, X, AM-HS = %1i, AM-SB = %1i, AM-NS = %1i, AM-GB = %1i, AM-St = %1i, X, X \r\n", 
	MC_Betrieb_Modus, MC_NotStopp, MC_Responce_Modus, Bahn_Automatik_HS_Modus, Bahn_Automatik_SB_Modus, Bahn_Automatik_NS_Modus, Bahn_Automatik_GB_Modus, Bahn_Automatik_St_Modus);
	return;										
	}	
	

//###################################################################################################################
// Bahn_NS = Bahn-Notstop ausfhren ausfhren
//--------------------------------------------------------------------------------------------------------------------
void set_MC_Bahn_NotStopp(void)
	{ 
	unsigned char	Block_Nr, FahrStufe_Nr, St_Karten_Nr; 

	// alle MC-Timer-Register = 0 ------------------------------------------
	for (Block_Nr = 1; Block_Nr <= 32; Block_Nr++)   					// Block-Nr [1..32] - Regelung
		{
		Timer_Block_FS_soll_Register[Block_Nr] = 0;
		Timer_Block_FS_ist_Register[Block_Nr] =	0;
		Timer_Block_FS_Delay_Register[Block_Nr] = 0;
		}	

	// alle MC-Fahrstufen-Register = 0 -------------------------------------------------------------------------
	for (FahrStufe_Nr = 0; FahrStufe_Nr < Fahrstufen_MAX; FahrStufe_Nr++)	// alle Fahrstufen-Register = 0
		{
		FahrStufe[FahrStufe_Nr][0] = 0;
		FahrStufe[FahrStufe_Nr][1] = 0;
		FahrStufe[FahrStufe_Nr][2] = 0;
		FahrStufe[FahrStufe_Nr][3] = 0;
		}
	
	MC_Responce_Modus = 0;			// MC-Rckmeldung = 0
	MC_Test_Modus = 0;				// MC-Test = 0
	Bahn_Automatik_Modus = 0;		// Bahn-Automatic = 0

	// alle MC-Register = 0 ------------------------------------------
	for (Block_Nr = 1; Block_Nr < 33; Block_Nr++)   				
		{
		Block_Status_Register[Block_Nr] = 0;							// alle Block-FS-soll = 0
		Block_Aktiv_Register[Block_Nr] = 0;								// alle Block-FS-soll = 0
//		Block_FS_max_Register[Block_Nr] = 0;							// alle Block-FS-soll = 0
//		Block_FS_min_Register[Block_Nr] = 0;							// alle Block-FS-soll = 0
		Block_FS_soll_Register[Block_Nr] = 0;							// alle Block-FS-soll = 0
//		Block_FS_Delay1_Register[Block_Nr] = 0;							// alle Block-FS-soll = 0
//		Block_FS_Delay2_Register[Block_Nr] = 0;							// alle Block-FS-soll = 0
		Timer_Block_FS_soll_Register[Block_Nr] = 0;						// alle Timer-Block-FS-soll = 0
		Timer_Block_FS_Delay_Register[Block_Nr] = 0; 					// alle Timer-Block-FS-Delay = 0
		Timer_Block_FS_ist_Register[Block_Nr] = 0; 						// alle Timer-Block-FS-ist = 0
		};

	for ( St_Karten_Nr = 0;  St_Karten_Nr < 35;  St_Karten_Nr++)
		Strecken_Status_Register[St_Karten_Nr] = 0;						// alle Strecken_Register = 0
	set_MC_Bahn_RACK();													// Ausgabe an Bahn-Hardware
	
	// MC-Rckmeldung --- MC SteuerRegister anzeigen ----------------------------------
	usart_write("Bahn-Notstopp !!\r\n");									// MC-Betriebsmodus = 0
	usart_write("MC-Register --> BM = %1i, NS = %1i, RM = %1i, X, X, AM-HS = %1i, AM-SB = %1i, AM-NS = %1i, AM-GB = %1i, AM-St = %1i, X, X \r\n", 
	MC_Betrieb_Modus, MC_NotStopp, MC_Responce_Modus, Bahn_Automatik_HS_Modus, Bahn_Automatik_SB_Modus, Bahn_Automatik_NS_Modus, Bahn_Automatik_GB_Modus, Bahn_Automatik_St_Modus);
	return;  																// Nicht sinnloser Eintrag
	}

//###################################################################################################################
// Bahn-INIT
// Alle MC-Bahn-Werte = 0
//--------------------------------------------------------------------------------------------------------------------
void set_MC_Bahn_INIT(void)
	{ 
	unsigned char St_Karten_Nr, Block_Nr; 
	unsigned char CheckSumme;

	MC_Responce_Modus = 0;													// MC-Rckmeldung aus
	MC_Test_Modus = 0;
	Bahn_Automatik_Modus = 0;

	for (St_Karten_Nr = 1;  St_Karten_Nr < 35;  St_Karten_Nr++)					
		{Strecken_Status_Register[St_Karten_Nr] = 0;}					// alle Strecken_Register = [00]
	set_MC_Bahn_RACK();													// Ausgabe an Bahn-Hardware

	for (Block_Nr = 1;  Block_Nr <= 32;  Block_Nr++)					
		{
		Block_Status_Register[Block_Nr] = 0;							// alle Block-Status = 0
		Block_Aktiv_Register[Block_Nr] = 0;								// alle Block-Aktiv = 0
		Block_Delay_Register[Block_Nr] = 0;								// alle Block-Delay = 0
		Block_FS_max_Register[Block_Nr] = 0;							// alle Block-FS-MAX = 0
		Block_FS_min_Register[Block_Nr] = 0;							// alle Block-FS-MIN = 0
		Block_FS_Delay1_Register[Block_Nr] = 0;							// alle Block-FS-Delay1 = 0
		Block_FS_Delay2_Register[Block_Nr] = 0;							// alle Block-FS-Delay2 = 0
		Block_FS_soll_Register[Block_Nr] = 0;							// alle Block-FS-soll = 0
		Timer_Block_FS_soll_Register[Block_Nr] = 0;						// alle Timer-Block-FS-soll = 0
		Timer_Block_FS_Delay_Register[Block_Nr] = 0; 					// alle Timer-Block-FS-Delay = 0
		Timer_Block_FS_ist_Register[Block_Nr] = 0; 						// alle Timer-Block-FS-ist = 0
		} 

	// PC-Anzeige -------------------------------------------------------------
	CheckSumme = 0;
	usart_write("MC-INIT !!\r\n");
	usart_write("MC-Port-D = [1__1.1___]\r\n");
	usart_write("MC-Port-A = [0000.0000]\r\n");
	usart_write("MC-Port-C = [0000.0000]\r\n");
	// MC-Rckmeldung --- MC Steuer-Register anzeigen ----------------------------------
	usart_write("MC-Register --> BM = %1i, NS = %1i, RM = %1i, X, X, AM-HS = %1i, AM-SB = %1i, AM-NS = %1i, AM-GB = %1i, AM-St = %1i, X, X \r\n", 
	MC_Betrieb_Modus, MC_NotStopp, MC_Responce_Modus, Bahn_Automatik_HS_Modus, Bahn_Automatik_SB_Modus, Bahn_Automatik_NS_Modus, Bahn_Automatik_GB_Modus, Bahn_Automatik_St_Modus);
	}

//###################################################################################################################
// Bahn-RACK
// direkte Ausgabe des MC-Strecken_Status_Register an die Bahn-Hardware 
//--------------------------------------------------------------------------------------------------------------------
void set_MC_Bahn_RACK(void)
	{ 
	unsigned char St_Karten_Nr;			// St-Karten-Nr [1..35] --- 35 Eisenbahnkarten im Rack

	// MC und Inteface Output -----
	PORTD |= _BV(7);									// MC-D7 auf 1 => 74LS154 Encoder nicht aktiv
	PORTD |= _BV(3);									// MC-D3 auf 1 => 74LS245 Interface-Daten output
	PORTD &= 255-_BV(4);								// MC-D4 auf 0 => 74LS245 Interface-Daten aktiv
	DDRC = 0xFF;										// MC-Port-C Daten Output
	// Streckenteile aktualisieren -------
	for (St_Karten_Nr = 1; St_Karten_Nr < 35; St_Karten_Nr++)   	// Karten-Nr [0..34]
		{
		PORTA = St_Karten_Nr;	 						// Port-A => Adresse der Karte ausgeben
		asm("nop");
		PORTC = Strecken_Status_Register[St_Karten_Nr];		// Port-C => Strecken-Register-Nr beginnt mit 1 => KartenAdresse beginnt mit 0
		asm("nop");
		PORTD &= 255-_BV(7);							// MC-Steuer-Port-D7 = 0 => 74LS154 Decoder
		asm("nop");										// !!!! mindestens 4 * NOP
		asm("nop");
		asm("nop");
		asm("nop");
		asm("nop");
		asm("nop");
		PORTD |= _BV(7);								// MC-Steuer-Port-D => Karten-CS 74LS244 = deaktiv
		}
	// Interface Grundstellung -----
	PORTD |= _BV(7);									// MC-D7 auf 1 => 74LS154 Encoder nicht aktiv
	PORTD |= _BV(3);									// MC-D3 auf 1 => 74LS245 Interface-Daten output
	PORTD |= _BV(4);									// MC-D4 auf 1 => 74LS245 Interface-Daten inaktiv
	PORTA = 0x00;										// MC-Port-D Adresse = [00]
	PORTC = 0x00;										// MC-Port-C Daten = [00]

	// MC-Rckmeldung --- MC Steuer-Register anzeigen ----------------------------------
	usart_write("MC-Register --> BM = %1i, NS = %1i, RM = %1i, X, X, AM-HS = %1i, AM-SB = %1i, AM-NS = %1i, AM-GB = %1i, AM-St = %1i, X, X \r\n", 
	MC_Betrieb_Modus, MC_NotStopp, MC_Responce_Modus, Bahn_Automatik_HS_Modus, Bahn_Automatik_SB_Modus, Bahn_Automatik_NS_Modus, Bahn_Automatik_GB_Modus, Bahn_Automatik_St_Modus);
	}

//###################################################################################################################
// Strecken-Status-Register schreiben
// Streckenteile ein- oder ausschalten
//###################################################################################################################
void set_MC_Bahn_Strecken_Status(void)
	{
	unsigned char 	VarStRegNr;		// Variable-Nr fr St-Register-Nr [0..34] --- 35 * 8 = 280 Streckenteile in einem Register
	unsigned char 	StRegNr;		// St-Register-Nr [1..35] --- 35 * 8 = 280 Streckenteile in einem Register
	unsigned 		CheckSumme;

	// Strecken-Stringauf Strecken_Status_Register[1..35(Byte)] verteilen
	for (VarStRegNr = 1; VarStRegNr <= 32; VarStRegNr++) 
		{
		Strecken_Status_Register[VarStRegNr] = variable[VarStRegNr];			// Variablen [0..x]
		};

	// MC-Rckmeldung -- Anzeige Strecken_Status_Register (Walder) -----------------------------
	CheckSumme = 0;
	usart_write("St1          ");
	for (StRegNr = 1; StRegNr <= 16; StRegNr++)
		{
		usart_write("%3i ",Strecken_Status_Register[StRegNr]);
		if ((StRegNr % 8) == 0)
			{usart_write(" ");};
		};
	usart_write("\r\n");
	usart_write("St2          ");
	for (StRegNr = 17; StRegNr <= 32; StRegNr++)
		{
		usart_write("%3i ",Strecken_Status_Register[StRegNr]);
		if ((StRegNr % 24) == 0)
			{usart_write(" ");};
		};
	for (StRegNr = 1; StRegNr <= 32; StRegNr++)
		CheckSumme = CheckSumme + Strecken_Status_Register[StRegNr];
	usart_write("  CS = %i \r\n", CheckSumme);

	// direkte Ausgabe des Strecken_Status_Register im BM = 1 -------------------------------
	if (MC_Betrieb_Modus == 1)
		{
		set_MC_Bahn_RACK();
		}

	MC_Bahn_Timer_Register_aktualisieren();								// Timer-Register fr MAIN aktualisieren
	STR_NEU = 1;														// neue STR-Werte fr Timerausgabe
	return;
	}

//@###################################################################################################################
//@ Block-Daten setzen ===> [Block_Nr] [Status] [Aktiv] [Delay] [FS-max] [FS-min] [FS-Delay1] [FS-Delay2]
//@ Block-Nummer, Block-Status, Block-Aktiv, Block-Delay, Block-FS-max, Block-FS-min, Block-FS-Delay1, Block-FS-Delay2 
//@###################################################################################################################
void set_MC_Bahn_Block_Daten(void)
	{
	unsigned char BlDaNr;					// Block-Nummer [1..32]
	unsigned      CheckSumme;
	
	BlDaNr 								= variable[1];
	Block_Status_Register[BlDaNr] 		= variable[2];
	Block_Aktiv_Register[BlDaNr] 		= variable[3];
	Block_Delay_Register[BlDaNr] 		= variable[4];
	Block_FS_max_Register[BlDaNr] 		= variable[5];
	Block_FS_min_Register[BlDaNr] 		= variable[6];
	Block_FS_Delay1_Register[BlDaNr] 	= variable[7];
	Block_FS_Delay2_Register[BlDaNr] 	= variable[8];
	
	MC_Bahn_Timer_Register_aktualisieren();										// Timer-Register fr MAIN aktualisieren

	// MC-Rckmeldung -- Anzeige Block-Daten -----------------------------
	CheckSumme = 0;
	usart_write ("Block %2i => %2i %2i %2i - F %2i %2i - D %2i %2i", BlDaNr, Block_Status_Register[BlDaNr], Block_Aktiv_Register[BlDaNr], Block_Delay_Register[BlDaNr], 
			Block_FS_max_Register[BlDaNr], Block_FS_min_Register[BlDaNr], Block_FS_Delay1_Register[BlDaNr], Block_FS_Delay2_Register[BlDaNr]);
	CheckSumme  = BlDaNr + Block_Status_Register[BlDaNr] + Block_Aktiv_Register[BlDaNr] + Block_Delay_Register[BlDaNr] + 
					Block_FS_max_Register[BlDaNr] + Block_FS_min_Register[BlDaNr] + Block_FS_Delay1_Register[BlDaNr] +  Block_FS_Delay2_Register[BlDaNr];
	usart_write("   CS=%i \r\n", CheckSumme);
	}

//###################################################################################################################
// Block-Status-Register ==> Block ist nicht rot !"
// [0..32] Werte in Block-Status-Register schreiben
// 		Bl_Status = 0  oder 1
//###################################################################################################################
void set_MC_Bahn_Block_Status(void)
	{
	unsigned char BlNrSt;																// Block-Nummer [1..32]
	unsigned      CheckSumme;

	for (BlNrSt = 1; BlNrSt <= 32; BlNrSt++)   					// Block-Nr [1..32] - Regelung ==> Variablen [0..x]
		{
		Block_Status_Register[BlNrSt] = variable[BlNrSt];
		}       					

	MC_Bahn_Timer_Register_aktualisieren();								// Timer-Register fr MAIN aktualisieren

	// MC-Rckmeldung -- Anzeige Block_Status_Register -----------------------------
	CheckSumme = 0;
	usart_write("Bl-Status....");
	for (BlNrSt = 1; BlNrSt <= 32; BlNrSt++)
		{
		usart_write("%2i ", Block_Status_Register[BlNrSt]);
		if (((BlNrSt % 8) == 0) && (BlNrSt < 32))
		  {usart_write(" ");};
		CheckSumme  = CheckSumme + Block_Status_Register[BlNrSt];
		};
	usart_write("  CS=%i \r\n", CheckSumme);
	}

//###################################################################################################################
// Block-Aktiv-Register ==> Block stellt neue Geschwindigkeit ein
// [0..32] Werte in Block-Aktiv-Register schreiben
// 		Bl_Aktiv = 0  =>  Timer-Block-FS-soll[i] = Block-FS-soll[i]
// 		Bl_Aktiv = 1  =>  Timer-Block-FS-soll[i] = Block-FS-Vmax[i]
// 		Bl_Aktiv = 2  =>  Timer-Block-FS-soll[i] = Block-FS-min[i]
//###################################################################################################################
void set_MC_Bahn_Block_Aktiv(void)
	{
	unsigned char BlNrA;																// Block-Nummer [1..32]
	unsigned      CheckSumme;

	for (BlNrA = 1; BlNrA <= 32; BlNrA++)   											// Block-Nr [1..32] - Regelung ==> Variablen [0..x]
		{
		Block_Aktiv_Register[BlNrA] = variable[BlNrA];
		if (Block_Aktiv_Register[BlNrA] == 0)
		  {
		  Block_FS_soll_Register[BlNrA] = 0;
		  }
		} 

	// MC-Rckmeldung -- Anzeige Block_Aktiv_Register -----------------------------
	CheckSumme = 0;
	usart_write("Bl-Aktiv.....");
	for (BlNrA = 1; BlNrA <= 32; BlNrA++)
		{
		usart_write("%2i ", Block_Aktiv_Register[BlNrA]);
		if (((BlNrA % 8) == 0) && (BlNrA < 32))
		  {usart_write(" ");};
		CheckSumme  = CheckSumme + Block_Aktiv_Register[BlNrA];
		};
	usart_write("  CS=%i \r\n", CheckSumme);

	MC_Bahn_Timer_Register_aktualisieren();												// Timer-Register fr MAIN aktualisieren
	}

//###################################################################################################################
// Bahn_Block_FS_max ==> maximale Geschindigkeit
// [0..32] Werte in Block-FS-max-Rregister schreiben
//###################################################################################################################
void set_MC_Bahn_Block_FS_max(void)
	{
	unsigned char BlNrMX;																// Block-Nummer [1..32]
	unsigned      CheckSumme;

	for (BlNrMX = 1; BlNrMX <= 32; BlNrMX++)   										// Block-Nr [1..32] - Regelung ==> Variablen [0..x]
		{			
		Block_FS_max_Register[BlNrMX] = variable[BlNrMX];
		if (Block_FS_max_Register[BlNrMX] > Fahrstufen_MAX)	
		  {
		  Block_FS_max_Register[BlNrMX] = Fahrstufen_MAX;
		  }
		} 

	MC_Bahn_Timer_Register_aktualisieren();								// Timer-Register fr MAIN aktualisieren

	// MC-Rckmeldung -- Anzeige Block_FS_max_Register -----------------------------
	CheckSumme = 0;
	usart_write("Bl-FS-max....");
	for (BlNrMX = 1; BlNrMX <= 32; BlNrMX++)
		{
		usart_write("%2i ", Block_FS_max_Register[BlNrMX]);
		if (((BlNrMX % 8) == 0) && (BlNrMX < 32))
		  {usart_write(" ");};
		CheckSumme  = CheckSumme + Block_FS_max_Register[BlNrMX];
		}
	usart_write("  CS=%i \r\n", CheckSumme);
	}

//###################################################################################################################
// Bahn_Block_FS_min ==> minimale Geschwindigkeit
// [0..32] Werte in Block-FS-min-Rregister schreiben
//###################################################################################################################
void set_MC_Bahn_Block_FS_min(void)
	{
	unsigned char BlNrMI;
	unsigned      CheckSumme;

	for (BlNrMI = 1; BlNrMI <= 32; BlNrMI++)   					// Block-Nr [1..32] - Regelung ==> Variablen [0..x]
		{
		Block_FS_min_Register[BlNrMI] = variable[BlNrMI];
		if (Block_FS_min_Register[BlNrMI] > Fahrstufen_MAX)						//Achtung Variablen beginnen mit dem Index 0
		  {
		  Block_FS_min_Register[BlNrMI] = Fahrstufen_MAX - 1;
		  }
		}       										
	MC_Bahn_Timer_Register_aktualisieren();								// Timer-Register fr MAIN aktualisieren
	
	// MC-Rckmeldung -- Anzeige Block_FS_min_Register -----------------------------
	CheckSumme = 0;
	usart_write("Bl-FS-min....");
	for (BlNrMI = 1; BlNrMI <= 32; BlNrMI++)
		{
		usart_write("%2i ", Block_FS_min_Register[BlNrMI]);
		if (((BlNrMI % 8) == 0) && (BlNrMI < 32))
		  {usart_write(" ");};
		CheckSumme  = CheckSumme + Block_FS_min_Register[BlNrMI];
		};
	usart_write("  CS=%i \r\n", CheckSumme);
	}

//###################################################################################################################
// Bahn-Block-Delay ==> Startverzgerung
// [0..32] Werte in Block-Delay-Register schreiben
//###################################################################################################################
void set_MC_Bahn_Block_Delay(void)
	{
	unsigned char BlNrD;												// Block-Nummer [1..32]
	unsigned      CheckSumme;

	for (BlNrD = 1; BlNrD <= 32; BlNrD++)   					// Block-Nr [1..32] - Regelung ==> Variablen [0..x]
		{ 
		Block_Delay_Register[BlNrD] = variable[BlNrD];
		if (Block_Delay_Register[BlNrD] > 80)				
		  {
		  Block_Delay_Register[BlNrD] = 80;
		  }
		}

	// MC-Rckmeldung -- Anzeige Block_Delay_Register -----------------------------
	CheckSumme = 0;
	usart_write("Bl-Delay.....");
	for (BlNrD = 1; BlNrD <= 32; BlNrD++)
		{
		usart_write("%2i ", Block_Delay_Register[BlNrD]);
		if (((BlNrD % 8) == 0) && (BlNrD < 32))
		  {usart_write(" ");};
		CheckSumme  = CheckSumme + Block_Delay_Register[BlNrD];
		};
	usart_write("  CS=%i \r\n", CheckSumme);
	}

//###################################################################################################################
// Block-FS-Delay1 ==> beschleunigen
// [0..32] Werte in Block-FS-Delay-Register schreiben
//###################################################################################################################
void set_MC_Bahn_Block_FS_Delay1(void)
	{
	unsigned char BlNrD1;												// Block-Nummer [0..34]
	unsigned      CheckSumme;

	for (BlNrD1 = 1; BlNrD1 <= 32; BlNrD1++)   					// Block-Nr [1..32] - Regelung ==> Variablen [0..x]
		{
		Block_FS_Delay1_Register[BlNrD1] = variable[BlNrD1];       		// Achtung Variablen beginnen bei Index 0
		if (Block_FS_Delay1_Register[BlNrD1] > 80)	
		  {
		  Block_FS_Delay1_Register[BlNrD1] = 80;
		  }
		}

	// MC-Rckmeldung -- Anzeige Block_FS_Delay1_Register ----------------------------
	CheckSumme = 0;
	usart_write("Bl-Delay-1...");
	for (BlNrD1 = 1; BlNrD1 <= 32; BlNrD1++)
		{
		usart_write("%2i ", Block_FS_Delay1_Register[BlNrD1]);
		if (((BlNrD1 % 8) == 0) && (BlNrD1 < 32))
		  {usart_write(" ");};
		CheckSumme  = CheckSumme + Block_FS_Delay1_Register[BlNrD1];
		};
	usart_write("  CS=%i \r\n", CheckSumme);
	}

//###################################################################################################################
// Block-FS-Delay2 ==> bremsen
// [0..32] Werte in Block-FS-Delay-Register schreiben
//###################################################################################################################
void set_MC_Bahn_Block_FS_Delay2(void)
	{
	unsigned char BlNrD2;												// Block-Nummer [0..34]
	unsigned      CheckSumme;

	for (BlNrD2 = 1; BlNrD2 <= 32; BlNrD2++)   					// Block-Nr [1..32] - Regelung ==> Variablen [0..x]
		{
		Block_FS_Delay2_Register[BlNrD2] = variable[BlNrD2];
		if (Block_FS_Delay2_Register[BlNrD2] > 80)
		  {
		  Block_FS_Delay2_Register[BlNrD2] = 80;
		  }
		}

	// MC-Rckmeldung -- Anzeige Block_FS_Delay2_Register -----------------------------
	CheckSumme = 0;
	usart_write("Bl-Delay-2...");
	for (BlNrD2 = 1; BlNrD2 <= 32; BlNrD2++)
		{
		usart_write("%2i ", Block_FS_Delay2_Register[BlNrD2]);
		if (((BlNrD2 % 8) == 0) && (BlNrD2 < 32))
		  {usart_write(" ");};
		CheckSumme  = CheckSumme + Block_FS_Delay2_Register[BlNrD2];
		};
	usart_write("  CS=%i \r\n", CheckSumme);
	}

//###################################################################################################################
// Bahn_Block_FS_soll ==> vorgegebene Geschwindigkeit
// [0..32] Werte in Block-FS-soll-Rregister schreiben
//###################################################################################################################
void set_MC_Bahn_Block_FS_soll(void)
	{
	unsigned char BlNrS;
	unsigned      CheckSumme;

	for (BlNrS = 1; BlNrS <= 32; BlNrS++)   					// Block-Nr [1..32] - Regelung ==> Variablen [0..x]
		{
		Block_FS_soll_Register[BlNrS] = variable[BlNrS];
		if (Block_FS_soll_Register[BlNrS] > Fahrstufen_MAX)
		  {
		  Block_FS_soll_Register[BlNrS] = Fahrstufen_MAX;
		  }
		}

	if (Bahn_Automatik_Modus == 1)											// nur bei Einzelsteuerung bertragen
		MC_Bahn_Timer_Register_aktualisieren();								// Timer-Register fr MAIN aktualisieren
	
	// MC-Rckmeldung -- Anzeige Block_FS_soll_Register -----------------------------
	CheckSumme = 0;
	usart_write("Bl-soll......");
	for (BlNrS = 1; BlNrS <= 32; BlNrS++)
		{
		usart_write("%2i ", Block_FS_soll_Register[BlNrS]);
		if (((BlNrS % 8) == 0) && (BlNrS < 32))
		  {usart_write(" ");};
		CheckSumme  = CheckSumme + Block_FS_soll_Register[BlNrS];
		};
	usart_write("  CS=%i \r\n", CheckSumme);
	}

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@@ BM	-	MC-BM auf allen EB-Karten Belegmessung
//@@------------------------------------------------------------------------------------------------------------------
/*
void get_Bahn_Block_Test(void)
	{
	unsigned char BMBeNr;																				// Beleg-Register-Nr
	unsigned int Strecken_Karten_Adresse;																// Adresse der Block- und Streckenkarten

	//@@ Belegwerte von Eisenbahn-Hardware auslesen
	if (MC_Betrieb_Modus < 3)
		{
		//@@ TestLed zum Prfen ob die Funktion ausgefhrt wird !!
		if (TestLed == 0)
			{ 
			PORTD |= _BV(6);
			TestLed = 1;
			}
		else	
			{ 
			PORTD &= 255-_BV(6);
			TestLed = 0;
			}
		//@@ MC und Inteface Daten-Input
		//@@ MC und Interface Richtung fr Daten umschalten zur Belegmessung
		PORTD |= _BV(7);																				// MC-D7 auf 1 => 74LS154 Encoder sperrt
		DDRC = 0x00;																					// MC-Port-C (Daten) als Eingang
		PORTC = 0xFF; 																					// MC-Port-C (Daten) als Eingang - with pull-ups enabled
		PORTD &= 255-_BV(3);																			// MC-Steuer-Port-D = [____.0___] => Interface-74LS245 Daten IN
		PORTD &= 255-_BV(4);																			// MC-Steuer-Port-D = [___0.____] => Interface-74LS245 Daten aktiv

		//@@ Delay fr 74LS245 Daten-Umschaltung und MC-Port-C (Daten) als Eingang - with pull-ups enabled
		asm("nop");
		asm("nop");
		asm("nop");
		asm("nop");
		asm("nop");
		asm("nop");

		//@@ Belegmeldung von 35 Karten auslesen
		for (Strecken_Karten_Adresse = 35; Strecken_Karten_Adresse < 39; Strecken_Karten_Adresse++)		// Karte-CS - Adresse-Port-A = [35..39]
			{
			PORTA = Karte_CS;																			// MC-Port-A => Adresse [35..69] = Karte-CS ausgeben
			PORTD &= 255-_BV(7);																		// MC-Steuer-Port-D = [0___.____] => Karten-CS 74LS244 = 0 = aktiv
			//@@ Delay fr 74LS245 Daten-Umschaltung und MC-Port-C (Daten) als Eingang - with pull-ups enabled
			asm("nop");
			asm("nop");
			asm("nop");
			asm("nop");
			asm("nop");
			asm("nop");
			//@@ Delay ENDE
			Beleg_Register[Strecken_Karten_Adresse - 35] = PINC;										// Einlesen von Karten-Adresse [35..39] * 8 Bit => Beleg-Array[0..34] speichern
			PORTD |= _BV(7);																			// MC-Steuer-Port-D = [1___.____] => Karten 74LS244 = 1 sperrt
			}
		DDRC &= 0xFF;																						// MC-Daten-Port-C als Ausgang
		}

	//@@ Belegwerte an PC senden
	usart_write("MC-BM ");
	for (BMBeNr = 1; BMBeNr <= 34; BMBeNr++) 															// Register 0..34 
		{usart_write("%3i ", Beleg_Register[BMBeNr]);};												// MC sendet an PC die Beleg-Register-Daten
	usart_write("\r\n");
	//@@ MC_Responce_Modus = 0;																			// MC-Rckmeldung aus
	}
*/

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@@ BM	-	MC-BM auf allen Streckenteile Belegmessung 
//@@ Karten_CS 01..35 Daten schreiben in 74LS377
//@@ Karten_CS 36..69 Beleg-Daten lesen aus 74LS244 
//@@ Steuerung-Gundzustand Port-D = 1xx1.1xxx
//@@ * D7 CS fr D-FlipFlop	und 74ls244 => D7 = 1 aktiv
//@@ * D4 CS fr Interface-Datentreiber 74LS245 => D4 = 0 aktiv
//@@ * D3 Richtung fr Interface-Datentreiber 74LS245 D3 = 1 schreiben, D3 = 0 Lesen
//@@ * Bit auf 0 => &= 255-_BV(x);
//@@ * Bit auf 1 => |= _BV(x);
//@@------------------------------------------------------------------------------------------------------------------
void get_MC_Bahn_Strecken_Beleg(void)
	{
	unsigned char BMBeNr;																				// Beleg-Register-Nr
	unsigned int Strecken_Karten_Adresse;																// Adresse der Block- und Streckenkarten

	//@@ Belegwerte von Eisenbahn-Hardware auslesen
	if (MC_Betrieb_Modus < 3)
		{
		//@@ TestLed zum Prfen ob die Funktion ausgefhrt wird !!
		if (TestLed == 0)
			{ 
			PORTD |= _BV(6);
			TestLed = 1;
			}
		else	
			{ 
			PORTD &= 255-_BV(6);
			TestLed = 0;
			}
	
		//@@ MC und Inteface Output
		PORTD |= _BV(7);																				// MC-D7 auf 1 => 74LS154 Encoder sperrt
		PORTD |= _BV(3);																				// MC-D3 auf 1 => 74LS245 Interface-Daten output
		PORTD &= 255-_BV(4);																			// MC-D4 auf 0 => 74LS245 Interface-Daten aktiv
		DDRC = 0xFF;																					// MC-Daten Port-C als Ausgang

		//@@ alle 32 Blockabschnitte und alle 248 Streckenabschnitte auf 0
		//@@ 74LS154 erzeugt CS mit fallender Flanke und 74LS377 bernimmt Daten
		for (Strecken_Karten_Adresse = 0; Strecken_Karten_Adresse < 35; Strecken_Karten_Adresse++)		// 35 Karte-CS - Adressen-Port-A = [0..34]
			{
			PORTA = Strecken_Karten_Adresse;															// 74LS154 CS fr Kartenadresse [0..34] ausgeben
			PORTC = 0x00;																				// MC-Daten-Port-C = [0000.0000] alle Streckenteile auf 0
			PORTD &= 255-_BV(7);																		// MC-Steuer-Port-D = [0___.____] => Karten-CS 74LS377 = 0
			asm("nop");																					// !!!! mindestens 4 * NOP
			asm("nop");
			asm("nop");
			asm("nop");
			asm("nop");
			PORTD |= _BV(7);																			// MC-Steuer-Port-D = [1___.____] => CS fr 74LS377 wieder auf 1
																										// Wert im 74LS377 speichern
			}

		//@@ MC und Inteface Daten-Input
		//@@ MC und Interface Richtung fr Daten umschalten zur Belegmessung
		PORTD |= _BV(7);																				// MC-D7 auf 1 => 74LS154 Encoder sperrt
		DDRC = 0x00;																					// MC-Port-C (Daten) als Eingang
		PORTC = 0xFF; 																					// MC-Port-C (Daten) als Eingang - with pull-ups enabled
		PORTD &= 255-_BV(3);																			// MC-Steuer-Port-D = [____.0___] => Interface-74LS245 Daten IN
		PORTD &= 255-_BV(4);																			// MC-Steuer-Port-D = [___0.____] => Interface-74LS245 Daten aktiv

		//@@ Delay fr 74LS245 Daten-Umschaltung und MC-Port-C (Daten) als Eingang - with pull-ups enabled
		asm("nop");
		asm("nop");
		asm("nop");
		asm("nop");
		asm("nop");
		asm("nop");

		//@@ Belegmeldung von 35 Karten auslesen
		for (Strecken_Karten_Adresse = 35; Strecken_Karten_Adresse < 69; Strecken_Karten_Adresse++)		// Karte-CS - Adresse-Port-A = [35..69]
			{
			PORTA = Karte_CS;																			// MC-Port-A => Adresse [35..69] = Karte-CS ausgeben
			PORTD &= 255-_BV(7);																		// MC-Steuer-Port-D = [0___.____] => Karten-CS 74LS244 = 0 = aktiv
			//@@ Delay fr 74LS245 Daten-Umschaltung und MC-Port-C (Daten) als Eingang - with pull-ups enabled
			asm("nop");
			asm("nop");
			asm("nop");
			asm("nop");
			asm("nop");
			asm("nop");
			//@@ Delay ENDE
			Beleg_Register[Strecken_Karten_Adresse - 35] = PINC;										// Einlesen von Karten-Adresse [35..69] * 8 Bit => Beleg-Array[0..34] speichern
			PORTD |= _BV(7);																			// MC-Steuer-Port-D = [1___.____] => Karten 74LS244 = 1 sperrt
			}
		}
	
	//@@ Belegmeldung von 35 Karten auslesen
	DDRC &= 0xFF;																						// MC-Daten-Port-C als Ausgang
	//	MC_Responce_Modus = 10;

	//@@ Belegwerte an PC senden
	usart_write("MC-BM ");
	for (BMBeNr = 1; BMBeNr <= 35; BMBeNr++) 															// Register 0..34 
		{usart_write("%3i ",Beleg_Register[BMBeNr]);};													// MC sendet an PC die Beleg-Register-Daten
	usart_write("\r\n");
	//@@ MC_Responce_Modus = 0;																			// MC-Rckmeldung aus
	}

//###################################################################################################################
//@@ KM	-	MC-KM auf allen EB-Karten Kurzschlussmessung
//--------------------------------------------------------------------------------------------------------------------
void get_MC_Bahn_Strecken_Kurzschluss(void)
	{
	unsigned char KMBeNr;																				// Kurzschluss-Register-Nr
	unsigned int Strecken_Karten_Adresse;																// Adresse der Block- und Streckenkarten

	//@@ Belegwerte von Eisenbahn-Hardware auslesen
	if (MC_Betrieb_Modus < 6)
		{
		//@@ TestLed zum Prfen ob die Funktion ausgefhrt wird !!
		if (TestLed == 0)
			{ 
			PORTD |= _BV(6);
			TestLed = 1;
			}
		else	
			{ 
			PORTD &= 255-_BV(6);
			TestLed = 0;
			}
		//@@ MC und Inteface Daten-Input
		//@@ MC und Interface Richtung fr Daten umschalten zur Belegmessung
		PORTD |= _BV(7);																				// MC-D7 auf 1 => 74LS154 Encoder sperrt
		DDRC = 0x00;																					// MC-Port-C (Daten) als Eingang
		PORTC = 0xFF; 																					// MC-Port-C (Daten) als Eingang - with pull-ups enabled
		PORTD &= 255-_BV(3);																			// MC-Steuer-Port-D = [____.0___] => Interface-74LS245 Daten IN
		PORTD &= 255-_BV(4);																			// MC-Steuer-Port-D = [___0.____] => Interface-74LS245 Daten aktiv

		//@@ Delay fr 74LS245 Daten-Umschaltung und MC-Port-C (Daten) als Eingang - with pull-ups enabled
		asm("nop");
		asm("nop");
		asm("nop");
		asm("nop");
		asm("nop");
		asm("nop");

		//@@ Belegmeldung von 35 Karten auslesen
		for (Strecken_Karten_Adresse = 35; Strecken_Karten_Adresse < 39; Strecken_Karten_Adresse++)		// Karte-CS - Adresse-Port-A = [35..39]
			{
			PORTA = Karte_CS;																			// MC-Port-A => Adresse [35..69] = Karte-CS ausgeben
			PORTD &= 255-_BV(7);																		// MC-Steuer-Port-D = [0___.____] => Karten-CS 74LS244 = 0 = aktiv
			//@@ Delay fr 74LS245 Daten-Umschaltung und MC-Port-C (Daten) als Eingang - with pull-ups enabled
			asm("nop");
			asm("nop");
			asm("nop");
			asm("nop");
			asm("nop");
			asm("nop");
			//@@ Delay ENDE
			Kurzschluss_Register[Strecken_Karten_Adresse - 35] = PINC;									// Einlesen von Karten-Adresse [35..39] * 8 Bit => Beleg-Array[0..34] speichern
			PORTD |= _BV(7);																			// MC-Steuer-Port-D = [1___.____] => Karten 74LS244 = 1 sperrt
			}
		DDRC &= 0xFF;																					// MC-Daten-Port-C als Ausgang
		}

	//@@ Kurzuschlusswerte an PC senden
	usart_write("MC-KM ");
	for (KMBeNr = 1; KMBeNr <=  34; KMBeNr++) 															// Register 0..34 
		{usart_write("%3i ",Kurzschluss_Register[KMBeNr]);};											// MC sendet an PC die Kurzschluss-Register-Daten
	usart_write("\r\n");
	//@@ MC_Responce_Modus = 0;																			// MC-Rckmeldung aus
	}



//###################################################################################################################
// Bahn-Timer-Register	-	fr MAIN laden
//--------------------------------------------------------------------------------------------------------------------
void MC_Bahn_Timer_Register_aktualisieren(void)
	{
	unsigned char TBlNr;
	
//	usart_write("=> Timer FS\r\n"); 


//#############################
// PROBLEM mit HS, NS, SB ...
	Bahn_Automatik_Modus = 1;


// Einelsteuerung ------------------------------------------------------------
	if (Bahn_Automatik_Modus == 0)
		{
		for (TBlNr = 1; TBlNr <= 32; TBlNr++)   					// Block-Nr [1..32] - Regelung
			{
			if (Block_Status_Register[TBlNr] == 1)
				{
				Timer_Block_FS_soll_Register[TBlNr] = Block_FS_soll_Register[TBlNr];
				Timer_Block_FS_Delay_Register[TBlNr] = Block_FS_Delay1_Register[TBlNr];	// mit FS-Delay1
				}
			else
				{
				Timer_Block_FS_soll_Register[TBlNr] = 0;
				Timer_Block_FS_ist_Register[TBlNr] = 0;
				Timer_Block_FS_Delay_Register[TBlNr] = 0;
				}
			}	
		}	
	
	// Automatiksteuerung ------------------------------------------------------------------------------------
	if (Bahn_Automatik_Modus != 0) 
		{
		for (TBlNr = 1; TBlNr <= 32; TBlNr++)   					// Block-Nr [1..32] - Regelung
			{
			if (Block_Status_Register[TBlNr] == 1)						// wenn Block "GRN"
				{
				switch (Block_Aktiv_Register[TBlNr])
					{
					// ==> Block-FS = 0 -----------------------------------------------------
					case 0 : 	Timer_Block_FS_soll_Register[TBlNr] = 0;
								Timer_Block_FS_Delay_Register[TBlNr] = 0;							// mit FS-Delay = 0
								break;
					// ==> Beschleunigen -------------------------------------------
					case 1 :	Timer_Block_FS_soll_Register[TBlNr] = Block_FS_max_Register[TBlNr];		// mit FS-MAX
								Timer_Block_FS_Delay_Register[TBlNr] = Block_FS_Delay1_Register[TBlNr];	// mit FS-Delay1
								break;
					// ==> Bremsen ------------------------------------------------
					case 2 : 	Timer_Block_FS_soll_Register[TBlNr] = Block_FS_min_Register[TBlNr];		// mit FS-MIN
								Timer_Block_FS_Delay_Register[TBlNr] = Block_FS_Delay2_Register[TBlNr];	// mit FS-Delay2
								break;
					// ==> FS-MAX ------------------------------------------------
					case 5 : 	Timer_Block_FS_soll_Register[TBlNr] = Block_FS_max_Register[TBlNr];		// mit FS-MAX
								Timer_Block_FS_ist_Register[TBlNr] = Block_FS_max_Register[TBlNr];			// mit FS-MAX
								Timer_Block_FS_Delay_Register[TBlNr] = 0;									// mit Timer_Block_FS_Delay = 0
								break;
					}
				}
			}	
		}	
	}


//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//
// Weichenbetrieb (BM = 3 )
//
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

//==============================================================================================================
// WeichenDaten ==> Reset
//==============================================================================================================
void set_MC_Bahn_Weichen_Reset(void)
	{
	// Weichen Daten INIT = alle Weichen Daten =[00]
	for (Weichen_Nr = 1; Weichen_Nr < 9; Weichen_Nr++)
		{
		WeichenDaten_links[Weichen_Nr]  = 0;
		WeichenDaten_rechts[Weichen_Nr] = 0;
		}
	usart_write("Weichen_Daten = [00] !\r\n");

	// Weichen-Daten = [00] an alle Weichenschalter ausgeben ----------------------------
	DDRC = 0xFF;																			// MC-Port-C Daten als Ausgang
	DDRD = 0xFF;																			// MC-Port-D Control als Ausgang
	PORTC = 0x00; 																		// MC-Port-C = [00] alle WeichenDaten = 0
	// CS D-FlipFlop fr alle WeichenSchalter 
	PORTD  &= 255 - _BV(6);													// MC-Port-D6 = [0] Weichen link = CS 1 - 0 - 1
	PORTD |= _BV(6);																	// MC-Port-D6 = [1]
	PORTD  &= 255 - _BV(7);													// MC-Port-D6 = [0] Weichen rechts = CS 1 - 0 - 1
	PORTD |= _BV(7);																	// MC-Port-D6 = [1]

	usart_write("Weichen[1..64] Daten = [00] !\r\n");
	}

//==============================================================================================================
// Weichen schalten
// WeichenNummern vom PC = 1..64 werden zur Ausgabe auf MC = 0..63 umgesetzt
//==============================================================================================================
void set_MC_Bahn_Weichen(void)
	{
	// WeichenDaten einlesen (PC = 1..64) -------------------------------------------------------------
	Weichen_Nr = variable[1];
	WeichenDaten_NEU[Weichen_Nr] = variable[2];
	// WeichenNummern vom PC = 1..64 werden zur Ausgabe auf MC = 0..63 umgesetzt
	PORTC |= _BV(Weichen_Nr - 1);													// MC-Port-Cx = [1]

	if (WeichenDaten_NEU[Weichen_Nr] == 0)
		{
		// wenn WeichenDaten_NEU == [0] dann Weichen links  
		// CS D-FlipFlop fr WeichenSchalter Links => Port D6 = [0] => [1] -----------------------
		PORTD  &= 255 - _BV(6);														// MC-Port-D6 = [0] Weichen link = CS 1 - 0 - 1
		PORTD |= _BV(6);																		// MC-Port-D6 = [1]
		usart_write("Weiche %2i => links gestellt !\r\n", Weichen_Nr);
		}
	else
		{
		// wenn WeichenDaten_NEU == [1] dann Weichen rechts
		// CS D-FlipFlop fr WeichenSchalter Rechts => Port D7 = [0] => [1] -----------------------
		PORTD  &= 255 - _BV(7);															// MC-Port-D7 = [0] Weichen rechts = CS 1 - 0 - 1
		PORTD |= _BV(7);																			// MC-Port-D7 = [1]
		usart_write("Weiche %2i => rechts gestellt !\r\n", Weichen_Nr);
		}

	// Weichen Rckstellung Delay -------------------------------------
	for (Weichen_TimerDelay = Weichen_Delay; Weichen_TimerDelay > 0; Weichen_TimerDelay--)
		{
		long_delay(10);
		}

	// 3. Weichen_Rckstellung ------------------------------
	// Alle Weichen-Infos = [00]
	PORTC = 0x00; 																		// MC-Port-C = [00]
	// CS D-FlipFlop fr alle WeichenSchalter 
	PORTD  &= 255 - _BV(6);													// MC-Port-D6 = [0] Weichen link = CS 1 - 0 - 1
	PORTD |= _BV(6);																	// MC-Port-D6 = [1]
	PORTD  &= 255 - _BV(7);													// MC-Port-D6 = [0] Weichen rechts = CS 1 - 0 - 1
	PORTD |= _BV(7);																	// MC-Port-D6 = [1]
//	usart_write("Weichen_Rckstellung !\r\n");
	}

//==============================================================================================================
// Weichenantrieb Delay
//==============================================================================================================
void set_MC_Bahn_Weichen_Delay(void)
	{
	Weichen_Delay = variable[1];
	if (variable[1] < 255)
		{Weichen_Delay = variable[1];}
	else
		{Weichen_Delay = 255;}

	Weichen_MC_TimerDelay = Weichen_Delay + 1000;
	usart_write("Weichen_Delay = %8i\r\n", Weichen_Delay);
	}
	



//  ENDE ------------------------------------------------------------------------------------------------------------------