/*------------------------------------------------------------------------------
 Eisenbahnsteuerung made by: Andreas Lutters / Achim Walder
 Revision:       10.10.2013


 portions by Ulrich Radig


 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
 GNU General Public License, wie von der Free Software Foundation verffentlicht, 
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
 (nach Ihrer Option) jeder spteren Version. 

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
 Programm erhalten haben. 
 Falls nicht, schreiben Sie an die Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
------------------------------------------------------------------------------*/
#ifndef _CMD_H_
	#define _CMD_H_	
	
	typedef struct
		{
		char* cmd;          								// Stringzeiger auf Befehlsnamen
		void(*fp)(void);  									// Zeiger auf auszufhrende Funktion
		} COMMAND_STRUCTUR;	
	
	#define MAX_VAR		40									// Maximale Anzahl von Variablen vom PC pro Befehl
	#define HELPTEXT	1
	
	// interne MC Befehle ----------------------------------------------------------------------
	extern unsigned char extract_cmd(char *);
	extern void command_time(void);
    extern void long_delay(int ms);   						// 11.10.2013 Defintion nachgetragen wegen Implicit


	// interne Bahn Befehle -----------------------------------------------------------------------
	void MC_Bahn_Timer_Register_aktualisieren(void);
 
	// MC Steuerbefehle -----------------------------------------------------------------------
	extern void set_MC_Reset(void);							// MC-Reset the unit
	extern void set_MC_ready(void);   						// MC betriebsbereit ?
	extern void set_MC_LED(void);   						// MC LED-Test
	extern void set_MC_INIT(void); 							// MC-INIT

	extern void show_help(void);							// MC Hilfe
	
	extern void show_MC_SteuerRegister(void);				// MC SteuerRegister anzeigen
	extern void show_MC_Bahn_Register(void);				// MC-Register anzeigen
	extern void show_MC_Bahn_Block_FSist(void);				// Bahn Block FS ist

	extern void set_MC_SteuerRegister(void);				// MC SteuerRegister setzen
	extern void set_MC_Betrieb_Modus(void);   				// MC-Betriebs-Modus 0,1,2,4,
	extern void set_MC_Bahn_Automatik_Modus(void);   		// Automatic-Modus 1,2,3,4,
	extern void set_MC_Response_Modus(void); 				// MC-Rckmeldung ON/OFF
	extern void set_MC_Test_Modus(void);					// MC-Test

	// MC Befehle fr Platinentest ----------------------------------------------------------------------
	extern void set_MC_Daten_NEU(void);						// MC-Port-C Grundzustand
	extern void set_MC_Daten_OUT(void);						// MC-Port-C Output
	extern void set_MC_Daten_IN(void);						// MC-Port-C Input
	extern void set_MC_Port_A_00(void);						// MC-Port-A auf [00]
	extern void set_MC_Port_C_00(void);						// MC-Port-C auf [00]
	extern void set_MC_Port_D_00(void);						// MC-Port-D auf [00]
	extern void set_MC_Port_A_FF(void);						// MC-Port-A auf [FF]
	extern void set_MC_Port_C_FF(void);						// MC-Port-C auf [FF]
	extern void set_MC_Port_A(void);						// MC-Port-A ein Bit setzen
	extern void set_MC_Port_C(void);						// MC-Port-C ein Bit setzen
	extern void set_MC_Port_D(void);						// MC-Port-D ein Bit setzen

	// Bahn Steuerbefehle -----------------------------------------------------------------------
	extern void set_MC_Bahn_INIT(void);   					// Befehl-INIT
	extern void set_MC_Bahn_NotStopp(void);   				// Befehl-NotStopp
	extern void set_MC_Bahn_RACK(void);   					// Befehlsausgabe an Eisenbahn-Rack

	// Bahn Blockabschnitte setzen --------------------------------------------------------------
	extern void set_MC_Bahn_Block_Daten(void);   			// Befehl Block-Daten setzen
	extern void set_MC_Bahn_Block_Status(void);   			// Befehl Block-Status-Regsiter setzen
	extern void set_MC_Bahn_Block_Aktiv(void);   			// Befehl Block-Aktiv-Regsiter setzen
	extern void set_MC_Bahn_Block_Delay(void);   			// Befehl Block-Delay-Register setzen
	extern void set_MC_Bahn_Block_FS_max(void);   			// Befehl Block-FS-max-Register setzen
	extern void set_MC_Bahn_Block_FS_min(void);   			// Befehl Block-FS-min-Register setzen
	extern void set_MC_Bahn_Block_FS_soll(void);   			// Befehl Block-FS-soll-Register setzen
	extern void set_MC_Bahn_Block_FS_Delay1(void);  		// Befehl FS-Delay1-Register (beschleunigen) setzen
	extern void set_MC_Bahn_Block_FS_Delay2(void);  		// Befehl FS-Delay2-Register (bremsen) setzen
	extern void set_MC_Bahn_Strecken_Status(void);   		// Befehl Strecken-Status-Register setzen


	extern void set_MC_Bahn_Weichen(void);		  				// Bahn Weiche schalten
	extern void set_MC_Bahn_Weichen_Reset(void);  			// Bahn Weiche Reset*
	extern void set_MC_Bahn_Weichen_Delay(void);  			// Bahn Weiche Delay*



//	extern void get_MC_Daten_Test(void);					// MC-Daten lesen und an PC bertragen
//	extern void get_MC_Bahn_Block_Test(void);				// Bahn Block-TestMessung

	extern void get_MC_Bahn_Strecken_Beleg(void);   		// Befehl Belegmeldung rcksenden
	extern void get_MC_Bahn_Strecken_Kurzschluss(void);		// Befehl Kurzschlussmeldung rcksenden
	
	#define RESET() {asm("ldi r30,0"); asm("ldi r31,0"); asm("ijmp");}
	
#endif //_CMD_H_
