/*----------------------------------------------------------------------------
 Eisenbahnsteuerung made by: Andreas Lutters / Achim Walder
 Revision:       19.10.2013

 portions by Ulrich Radig
 
 Version:        19.10.2013
 Description:    Webserver Config-File

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
 GNU General Public License, wie von der Free Software Foundation verffentlicht, 
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
 (nach Ihrer Option) jeder spteren Version. 

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
 Programm erhalten haben. 
 Falls nicht, schreiben Sie an die Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
------------------------------------------------------------------------------*/

#ifndef _CONFIG_H_
	#define _CONFIG_H_	
	 
	// ETH_M32_EX (www.ulrichradig.de)
	#define USE_ENC28J60	1   
	
	// Konfiguration der PORTS (HEX)
	// Achtung!!!! an PORTB ist der ENC - nur ndern wenn man wei was man macht!
	// 1=OUTPUT / 0=INPUT
	#define OUTA 		0x07           // 0000,1110
	#define OUTC 		0x06           // 0000.0110
	#define OUTD 		0x00           // 0000.0000   
	#define Port_D_Grundwerte 0b10011000; 							// von Achim 20.4.2017

    // Watchdog timer for the ENC2860, resets the stack if timeout occurs
    #define WTT 1200 												//Watchdog timer in timer interrupt
	
	// Umrechnung von IP zu unsigned long
	#define IP(a,b,c,d) ((unsigned long)(d)<<24)+((unsigned long)(c)<<16)+((unsigned long)(b)<<8)+a

	// IP des Webservers und des Routers
	#define MYIP		IP(192,168,106,175)
    #define ROUTER_IP	IP(192,168,106,97)

	// Netzwerkmaske
	#define NETMASK		IP(255,255,255,0)
	
	//MAC Adresse des Webservers
	#define MYMAC1	0x00
	#define MYMAC2	0x20
	#define MYMAC3	0x18
	#define MYMAC4	0xB1
	#define MYMAC5	0x15
	#define MYMAC6	0x6F
	 
	// Taktfrequenz
	// #define F_CPU 20000000UL
    // #define F_CPU 16000000UL	
	#define F_CPU 14745600UL
	// #define F_CPU 11059200UL
	
	//Timertakt intern oder extern
	#define EXTCLOCK 0 																				// 0 = Intern 1 = Externer Uhrenquarz

	// Baudrate der seriellen Schnittstelle oder USB
	// #define BAUDRATE   9600
	// #define BAUDRATE 115200
	#define BAUDRATE 230400																		// neu von Andreas Lutters
	
    // Commandos und Ausgaben erfolgen ber Telnet
    #define CMD_TELNET      0
	
	volatile unsigned timer_speed;														// Teiler fr Prozessorgeschwindigkeit
	  
	volatile unsigned pingpong;
	volatile unsigned TestLed;																// TestLed fr Steuerregister 
	volatile unsigned i;
	volatile unsigned ii;
	volatile unsigned Main_Counter;

	// MC --------------------------------------------------------------------------------------------------------------------------------------
	volatile unsigned char MC_Responce_Modus;									// MC RckmeldungControl-Byte
	volatile unsigned char MC_Betrieb_Modus;									// MC BetriebsControl-Byte
	volatile unsigned char MC_Test_Modus;											// MC TestControl-Byte
	volatile unsigned char MC_NotStopp;												// MC NotStopp


	// Bahn ------------------------------------------------------------------------------------------------------------------------------------
	volatile unsigned char Bahn_Automatik_Modus;							// AutomatikControl-Byte
	volatile unsigned char Bahn_Automatik_HS_Modus;						// AutomatikControl-Byte
	volatile unsigned char Bahn_Automatik_SB_Modus;						// AutomatikControl-Byte
	volatile unsigned char Bahn_Automatik_NS_Modus;						// AutomatikControl-Byte
	volatile unsigned char Bahn_Automatik_GB_Modus;						// AutomatikControl-Byte
	volatile unsigned char Bahn_Automatik_St_Modus;						// AutomatikControl-Byte

//	volatile unsigned KartenNr;															// Nummer der Streckenteilkarte (Block- und Signalkarten)
	volatile unsigned zeile;
	volatile unsigned spalte;
	volatile unsigned Signal[290];														// Streckenregister [1..280]
	volatile unsigned char STR_NEU;														// neuer Werte im Streckenteil-Register

	// PC ==> MC bergaberegister
	volatile unsigned char Strecken_Status_Register[40];			// 35 Streckenkarten = 280 Streckenteile 	[Datentype Byte]
	volatile unsigned char Block_Werte[15];										//  8 Block-Werte		 					[Datentype Byte]
	volatile unsigned char Block_Status_Register[35];					// 32 Block-Status-Werte 					[Datentype Byte]
	volatile unsigned char Block_Aktiv_Register[35];					// 32 Block-Aktiv-Werte 					[Datentype Byte]
	volatile unsigned char Block_Delay_Register[35];					// 32 Block-Strecken-Delay-Werte 			[Datentype Byte]
	volatile unsigned char Block_FS_max_Register[35];					// 32 Block-FS-soll-Werte mit 40 Fahrstufen [Datentype Byte]
	volatile unsigned char Block_FS_min_Register[35];					// 32 Block-FS-soll-Werte mit 40 Fahrstufen [Datentype Byte]
	volatile unsigned char Block_FS_soll_Register[35];				// 32 Block-FS-soll-Werte mit 40 Fahrstufen [Datentype Byte]
	volatile unsigned char Block_FS_Delay1_Register[35];			// 32 Block-FS-Delay1-Werte 				[Datentype Byte]
	volatile unsigned char Block_FS_Delay2_Register[35];			// 32 Block-FS-Delay1-Werte 				[Datentype Byte]

	// Register fr WeichenDaten
	volatile unsigned char Weichen_Nr;												// Weichen-Nummer
	volatile unsigned char WeichenDaten_NEU[100];							// Weichenstellung
	volatile unsigned char WeichenDaten_links[100];						// WeichenDaten links
	volatile unsigned char WeichenDaten_rechts[100];					// WeichenDaten rechts
	volatile unsigned char Weichen_Delay;											// Weichen-Delay
	volatile unsigned char Weichen_TimerDelay;								// Weichen-Delay
	volatile unsigned char Weichen_MC_TimerDelay;								// Weichen-Delay
	volatile unsigned char Weichen_NEU;												// Weichen neue Daten



	// Timer Ausgabe-Register
	volatile unsigned char Timer_Block_FS_soll_Register[35];	// 32 Time-Block-FS-soll-Werte 				[Datentype Byte]
	volatile unsigned char Timer_Block_FS_Delay_Register[35];	// 32 Time-Block-FS_Delay-Werte 			[Datentype Byte]
	volatile unsigned char Timer_Block_FS_ist_Register[35];		// 32 Block-FS-ist-Werte 					[Datentype Byte]
	
	// MC Fahrstufen-Ausgaberegister
	volatile unsigned char FahrStufe[85][4];									// FahrStufen-Array - 4 Blockkarten (8 Blcke) * x 80 Fahrstufen [Datentype Byte]

	volatile unsigned blinkers;
	volatile unsigned int Kurzschluss_Register[35];
	volatile unsigned int Beleg_Register[35];
	
	volatile unsigned ks_laufvariable;
	volatile unsigned bs_laufvariable;

	volatile unsigned Fahrstufen_MAX; 												// maximale Fahrstufen
	volatile unsigned Peek;     															// Peek-Zhler fr Timer 
	volatile unsigned Stufe;     		
	volatile unsigned BlockKarte;															// Blockkarten-Zhler
	volatile unsigned BK_Karten_Offset;												// Start fr Zhler

	volatile unsigned StRegisterAusgabe;						// Streckenregister-Ausgabe
	
	volatile unsigned int version;
	volatile unsigned uebergabe;
	
	volatile unsigned ksti;
	volatile unsigned bsti;
	volatile unsigned delay_groesse;
	volatile unsigned int Karte_CS;
	volatile unsigned int Delay_BS;
	volatile unsigned int ZaehlerNr;
	
	
	// #define Normale_Geschwindigkeit 30000; 					// ==> Radig
	#define Normale_Geschwindigkeit 30000;
	    
	#endif //_CONFIG_H






