/*---------------------/*----------------------------------------------------------------------------
 Main Program

 Eisenbahnsteuerung made by: Andreas Lutters / Achim Walder
 
 https://wolles-elektronikkiste.de/atmel-studio-7-ein-einstieg
 
----------------------------------------------------------------------------*/

#include <avr/io.h>
#include "config.h"
#include "usart.h"
#include "timer.h"
#include <util/delay.h>
#include "cmd.h"
#include <avr/eeprom.h>
// A.Fischer ==> sei() kann in main.c durch Hinzufgen der folgenden Header-Datei deklariert werden:
#include <util/atomic.h>

//$ simulavr -g -d atmega644p

//----------------------------------------------------------------------------
//Hier startet das Hauptprogramm
int main(void)
	{
	unsigned int 	USB_Counter;
	unsigned char 	Fahrstufe_Nr;
 	unsigned int 	spalte;
    unsigned long 	ProgrammStartDelay;					// ProgrammStartDelay - Verzgerung fr Programmstart
	unsigned char 	M_Block_Nr;  						// Main-Block-Nummer [1..32] [Datentype Byte]
	unsigned int 	i1;									// lokale Zhler
	unsigned int 	Sig_Nr;								// lokale Zhler fr Signale
//	unsigned TestLed;									// TestLed fr Steuerregister 
	
	//###############################################################################################################
	// intitialisierung von Variablen
	//###############################################################################################################

	MC_Responce_Modus = 1;								// MC-RckmeldungModus = 0 keine Rckmeldung
    MC_Betrieb_Modus = 0; 								// MC-BetriebsModus = 0
	MC_Test_Modus = 0;									// MC-TestModus = 0
	Bahn_Automatik_Modus = 0;							// MC-AutomatikModus = 0
	Bahn_Automatik_HS_Modus = 0;						// MC-AutomatikModus = 0
	Bahn_Automatik_SB_Modus = 0;						// MC-AutomatikModus = 0
	Bahn_Automatik_NS_Modus = 0;						// MC-AutomatikModus = 0
	Bahn_Automatik_GB_Modus = 0;						// MC-AutomatikModus = 0
	Bahn_Automatik_St_Modus = 0;						// MC-AutomatikModus = 0
	
	Peek = 0;  											// Peek-Zhler fr Timer
	Stufe = 0;
	zeile = 0;
    spalte = 0;
	
	BlockKarte = 0;     								// BlockKarten-Zhler
	BK_Karten_Offset = 35;								// Start fr Zhler
	Fahrstufen_MAX = 80;								// maximale Fahrstufe

	delay_groesse = 5; 									//Achtung schnelle Variante!
	Delay_BS = 200;										// Delay_BS = Wartepause   Default Wert fr BST Routine
	
	DDRA = OUTA;										// Konfiguration der Ausgnge bzw. Eingnge definition erfolgt in der config.h
	DDRC = OUTC;										// Konfiguration der Ausgnge bzw. Eingnge definition erfolgt in der config.h
	DDRD = OUTD;										// Konfiguration der Ausgnge bzw. Eingnge definition erfolgt in der config.h
	
	Main_Counter = 0;  									// Fahrstufen-Delay-Counter = 0 
 
	USB_Counter = 0;  									// USB-Counter = 0 

	for( i1 = 0; i1 < Fahrstufen_MAX; i1++)			// Initialisiere alle FahrStufen-Array = "0"
		{
		FahrStufe[i1][0] = 0;
		FahrStufe[i1][1] = 0;
		FahrStufe[i1][2] = 0;
		FahrStufe[i1][3] = 0;
		}
	
	for( M_Block_Nr = 0; M_Block_Nr <= 32; M_Block_Nr++)	// Initialisiere alle Block-Werte = "0"
		{
		Block_FS_max_Register[M_Block_Nr]		= 0;
		Block_FS_min_Register[M_Block_Nr]		= 0;
		Block_FS_soll_Register[M_Block_Nr] 		= 0;
		Block_FS_Delay1_Register[M_Block_Nr] 	= 0;
		Block_FS_Delay2_Register[M_Block_Nr] 	= 0;
		Block_Delay_Register[M_Block_Nr] 		= 0;
		}
			
		
	for( Sig_Nr = 0; Sig_Nr < 280; Sig_Nr++) 
		{
		Signal[Sig_Nr] = 0; 
		}
		
	usart_init(BAUDRATE); 								// setup the UART
	
	//############################################################################################################
	// Programmstart
	//###############################################################################################################
	//Timer starten
	timer_init();
	
	for(ProgrammStartDelay = 0; ProgrammStartDelay < 1000000; ProgrammStartDelay++)
		{asm("nop");};
		
	sei(); 											// Globale Interrupts einschalten
	timer_speed = Normale_Geschwindigkeit;    		// Achtung war 30000!!!  bm 4

	set_MC_LED();    								// Test fr MC_LED_Test + MC_INIT
  
	//###############################################################################################################################
	// Hauptschleife
	//###############################################################################################################################
	while(1)
		{
		//---------------------------------------------------------------------------------------------------------------------------
		// USB Schnittstelle berwachen 
		//---------------------------------------------------------------------------------------------------------------------------
		if (usart_status.usart_ready)
			{
			if(extract_cmd(&usart_rx_buffer[0]))
				{
				asm("nop");		
				//if (MC_Responce_Modus == 1) 
					//usart_write("   ==> USB ok !\r\n");
				}
			else 
				{
				usart_write("\r\n ==> [MAIN.C] USB-Error: %s\r\n", &usart_rx_buffer[0]);
				}
			usart_status.usart_ready = 0;
			}
			
		//###########################################################################################################################
		//
		// Betriebsmodus 4 ==> Impulsbreitensteuerung
		//
		//###########################################################################################################################
        if (MC_Betrieb_Modus == 4)
			{
			if (Main_Counter > 30 )				// Zhler fr Geschwindigkeitsnderungen
				{
				Main_Counter = 0;
				};
			Main_Counter = Main_Counter + 1;

			//########################################################################################################################################################
			// Geschwindigkeit in allen Blocks verndern
			//########################################################################################################################################################
			if (Main_Counter == 1)															
				{
				for (M_Block_Nr = 1; M_Block_Nr <= 32; M_Block_Nr++)													// fr alle 32 Blockabschnitte
					{

					// Bl-Aktiv gleich "0" ==> alle Werte auf "0"
					if ((Block_Status_Register[M_Block_Nr] == 0) || (Block_Aktiv_Register[M_Block_Nr] == 0))
						{
						Timer_Block_FS_Delay_Register[M_Block_Nr] = 0;													// mit 0 laden
						Timer_Block_FS_ist_Register[M_Block_Nr] = 0;													// FS auf "0"
						}

					// Bl-Aktiv ungleich "0" 
					if ((Block_Status_Register[M_Block_Nr] == 1) && (Timer_Block_FS_Delay_Register[M_Block_Nr] == 0))	// nur wenn Block = "GRN" und Timer = "0"
						{
						// Block - beschleunigen -----------------------------------
						if (Block_Aktiv_Register[M_Block_Nr] == 1)  													// nur wenn Aktiv = "1" 
							if (Timer_Block_FS_ist_Register[M_Block_Nr] < Timer_Block_FS_soll_Register[M_Block_Nr])		// ==> Beschleunigen
								{
								Timer_Block_FS_ist_Register[M_Block_Nr] = Timer_Block_FS_ist_Register[M_Block_Nr] + 1;	// FS + 1
								Timer_Block_FS_Delay_Register[M_Block_Nr] = Block_FS_Delay1_Register[M_Block_Nr];		// Beschleunigung-Delay1 wieder auf Anfangswert
								};
						// Block - bremsen -----------------------------------
						if (Block_Aktiv_Register[M_Block_Nr] == 2)														// nur wenn Aktiv = "2"
							if (Timer_Block_FS_ist_Register[M_Block_Nr] > Timer_Block_FS_soll_Register[M_Block_Nr])		// ==> Bemsen
								{
								Timer_Block_FS_ist_Register[M_Block_Nr] = Timer_Block_FS_ist_Register[M_Block_Nr] - 1;	// FS - 1
								Timer_Block_FS_Delay_Register[M_Block_Nr] = Block_FS_Delay2_Register[M_Block_Nr];		// Bremsen-Delay2 wieder auf Anfangswert
								};
						// Block - FS-MAX -----------------------------------
						if (Block_Aktiv_Register[M_Block_Nr] == 5)														// nur wenn Aktiv = "5"
							{
							Timer_Block_FS_ist_Register[M_Block_Nr] = Block_FS_max_Register[M_Block_Nr];				// mit FS-MAX
							Timer_Block_FS_Delay_Register[M_Block_Nr] = 0;												// mit Timer_Block_FS_Delay = 0
							}
						// Block - FS-SOLL -----------------------------------
						if (Block_Aktiv_Register[M_Block_Nr] == 9)														// nur wenn Aktiv = "9"
							{
							Timer_Block_FS_ist_Register[M_Block_Nr] = Block_FS_soll_Register[M_Block_Nr];				// mit FS-Soll
							Timer_Block_FS_Delay_Register[M_Block_Nr] = 0;												// mit Timer_Block_FS_Delay = 0
							}
						}
					else	
						{
						Timer_Block_FS_Delay_Register[M_Block_Nr] = Timer_Block_FS_Delay_Register[M_Block_Nr] - 1;
						};
					};
				};

			//########################################################################################################################################################
			// beschleunigen --- neue Geschwindigkeit in Fahrstufen_Array bertragen
			//########################################################################################################################################################
			if (Main_Counter == 10)	
				{
				for (M_Block_Nr = 1; M_Block_Nr <= 32; M_Block_Nr++)   														// Block-Nr [1..32] - Regelung
					{
					// Beschleunigen ----------------
					for ( Fahrstufe_Nr = 1; Fahrstufe_Nr < Timer_Block_FS_ist_Register[M_Block_Nr] + 1; Fahrstufe_Nr++ )  	// Fahrstufe +1
						{
						if ((M_Block_Nr >  0) && (M_Block_Nr < 9))       
							{
							FahrStufe[Fahrstufen_MAX - Fahrstufe_Nr][0] |= _BV(M_Block_Nr -  1);
							};
						if ((M_Block_Nr >  8) && (M_Block_Nr < 17)) 
							{
							FahrStufe[Fahrstufen_MAX - Fahrstufe_Nr][1] |= _BV(M_Block_Nr -  9);
							};
						if ((M_Block_Nr > 16) && (M_Block_Nr < 25)) 
							{
							FahrStufe[Fahrstufen_MAX - Fahrstufe_Nr][2] |= _BV(M_Block_Nr - 17);
							};
						if ((M_Block_Nr > 24) && (M_Block_Nr < 33)) 
							{
							FahrStufe[Fahrstufen_MAX - Fahrstufe_Nr][3] |= _BV(M_Block_Nr - 25);
							};
						}
					}
				};	

			//########################################################################################################################################################
			// bremsen --- neue Geschwindigkeit in Fahrstufen_Array bertragen
			//########################################################################################################################################################
			if (Main_Counter == 20)	
				{
				for (M_Block_Nr = 1; M_Block_Nr <= 32; M_Block_Nr++)   																// Block-Nr [1..32] - Regelung
					{
					// Bremsen ----------------
					for ( Fahrstufe_Nr = Timer_Block_FS_ist_Register[M_Block_Nr] + 1; Fahrstufe_Nr < Fahrstufen_MAX; Fahrstufe_Nr++ )  // Fahrstufe -1
						{
						if ((M_Block_Nr >  0) && (M_Block_Nr < 9))       
							{
							FahrStufe[Fahrstufen_MAX - Fahrstufe_Nr][0] &= 255-_BV(M_Block_Nr -  1);
							};
						if ((M_Block_Nr >  8) && (M_Block_Nr < 17)) 
							{
							FahrStufe[Fahrstufen_MAX - Fahrstufe_Nr][1] &= 255-_BV(M_Block_Nr -  9);
							};
						if ((M_Block_Nr > 16) && (M_Block_Nr < 25)) 
							{
							FahrStufe[Fahrstufen_MAX - Fahrstufe_Nr][2] &= 255-_BV(M_Block_Nr - 17);
							};
						if ((M_Block_Nr > 24) && (M_Block_Nr < 33)) 
							{
							FahrStufe[Fahrstufen_MAX - Fahrstufe_Nr][3] &= 255-_BV(M_Block_Nr - 25);
							};
						}	
					}	
				}
			}	

		}    	// Ende while (1)

	return(0);
	}