//##################################################################################
//  Timer Routinen
//  Eisenbahnsteuerung made by: Andreas Lutters / Achim Walder
//##################################################################################
// Revision:       01.11.2013
// portions by Ulrich Radig
// Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
// GNU General Public License, wie von der Free Software Foundation verffentlicht, 
// weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
// (nach Ihrer Option) jeder spteren Version. 
// Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
// da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
// sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
// FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 
// Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
// Programm erhalten haben. 
// Falls nicht, schreiben Sie an die Free Software Foundation, 
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
//  Program uses parts of the above mentioned Software of Ulrich Radig.
// All other code is solely public domain software contributed to the public under the 
// above mentioned GNU licence
//################################################################################

#include "config.h"
#include <avr/io.h>
#include <avr/interrupt.h>
#include "usart.h"
#include "cmd.h"
#include "timer.h"
//#include "stack.h"


volatile unsigned long time;
volatile unsigned long pin = 0;
volatile unsigned long time_watchdog = 0;

		unsigned char Block_Karten_Adresse;					// Block-Karten-Adresse
		unsigned char Strecken_Karten_Adresse;				// Strecken-Karten-Adresse
		unsigned char Pause;                                // Pause fr Ausgabe

//----------------------------------------------------------------------------
//Diese Routine startet und inizialisiert den Timer
void timer_init (void)
	{
	#if EXTCLOCK==1
		#if defined (__AVR_ATmega644__)
			//Asynchroner Modus ein, Oszillator an TOSC1 und TOSC2 aktiv
			ASSR |= (1 << AS2);
			TCCR2B = 0x05;
			while(ASSR & 0x11);
			//Capture/Compare-Interrupt aktiv
			TIMSK2 |= (1 << OCIE2A);
		#else
			//Asynchroner Modus ein, Oszillator an TOSC1 und TOSC2 aktiv
			ASSR  = (1 << AS2);
			//CTC-Modus an (Clear Timer on Compare Match)
			TCCR2 = (1 << WGM21);
			//dieser Wert ergibt eine Sekunde Periodendauer
			OCR2  = 31;
			//lsche Prescaler 2
			SFIE  = (1 << PSR2);
			//Starte Timer 2 mit Prescaler gleich 1/1024
			TCCR2 |= (1 << CS22)|(1 << CS21)|(1 << CS20);
			while(ASSR & 0x07);
			//Capture/Compare-Interrupt aktiv
			TIMSK = (1 << OCIE2);
		#endif
	#else
		TCCR1B |= (1 << WGM12) | (1 << CS10 | 0 << CS11 | 1 << CS12);
		TCNT1 = 0;
		OCR1A = timer_speed;      
//		OCR1A = (F_CPU / 1024) - 1;     //Org. Radig => F_CPU 11059200 -- 10800 = 1 Sekunde
		TIMSK |= (1 << OCIE1A);
	#endif
	return;
	};

	//----------------------------------------------------------------------------
	//Timer Interrupt
	#if EXTCLOCK==1
		#if defined (__AVR_ATmega644__)
			ISR (TIMER2_COMPA_vect)
		#else
			ISR (TIMER2_COMP_vect)
		#endif
	#else
		ISR (TIMER1_COMPA_vect)
	#endif
	
	
	//#############################################################################################################################
	// Timer Routine
	//#############################################################################################################################
	{   // tick 1 second
	time++;

	// MC_Betrieb_Modus = 3 - Weichensteuerung ---------------------------------------------------------------------------------------
	if ((MC_Betrieb_Modus == 3) && (Weichen_NEU = 1))
		{
		Weichen_MC_TimerDelay --;
		if (Weichen_MC_TimerDelay == 0)
			{
			DDRC = 0xFF;														// MC-Port-C output
			asm("nop");															// !!!! mindestens 4 * NOP
			asm("nop");
			asm("nop");
			asm("nop");
			asm("nop");
			asm("nop");
			PORTC = 0x00; 													// MC-Port-C = 00
			usart_write("Timer-Rckstellung !\r\n");
			Weichen_NEU = 0;
			}
		}


	// MC_Betrieb_Modus = 4 - Impuls-Weiten-Steuerung -------------------------------------------------------------------------------
	if (MC_Betrieb_Modus == 4)
		{
		// Test Timer
		PORTD |= _BV(6);

		//#############################################################################################################################
		// Impulsstufe fr die einzelnen Aufgaben 
		// Peek 1 bis 80 ==> Fahrstufen ausgeben
		// Peek 81 ==> alle Blocks und Streckenteile eingeschaltet = 12 Volt
		// Peek 82 ==> alle Blocks und Streckenteile Kurschluss eingesen
		// Peek 83 ==> alle Blocks und Streckenteile auf NULL
		// Peek 84 ==> alle Blocks und Streckenteile Beleg eingesen
		// Peek 85 ==> alle Blocks und Streckenteile wieder mit Stellung (rot/grn) laden
		//#############################################################################################################################	
//		if (Peek  > (Fahrstufen_MAX + 3))						// Zhler fr die Impulsstufen
//		if (Peek  > (Fahrstufen_MAX + 10))						// Zhler fr die Impulsstufen    # vom 22-12-2018 #
//			{Peek = 0;}

		Peek++;  // Zhler fr die Ausgabe

		// Test Timer - Auf dem Port D wir eine Bit angechaltet zum Messen der Zeit
		if (Peek  == 1)
			{
			PORTD |= _BV(5);
			PORTD &= 255-_BV(5);
			}

		//#############################################################################################################################
		// Geschwindigkeitsausgabe auf Blockkarten 
		//#############################################################################################################################
		if ((Peek > 0) && (Peek < (Fahrstufen_MAX + 1)))
			{
			// MC und Interface Output -----------------------------------------------------------------------------------------------------
			PORTD |= _BV(7);																				// MC-Port-D7 auf 1 => Encoder-74LS154 nicht aktiv, kein CS
			PORTD |= _BV(3);																				// MC-Port-D3 auf 1 => Interface-74LS245 Daten output
			PORTD &= 255-_BV(4);																			// MC-Port-D4 auf 0 => Interface-74LS245 Daten aktiv
			DDRC = 0xFF;																					// MC-Port-C output
			// Spalte = Blockkarte; Ziel = Fahrstufe -------------------------------------------------------------------------------
			for(Block_Karten_Adresse = 0; Block_Karten_Adresse <= 3; Block_Karten_Adresse++)				// Block-Karten-Adresse [0..3]
				{
				PORTA = Block_Karten_Adresse; 																// MC-Port-A => Adresse der Karte ausgeben
				PORTC = FahrStufe[Peek][Block_Karten_Adresse];												// MC-Port-C => Daten ausgeben
				PORTD &= 255-_BV(7);																		// MC-Port-D7 = 0 => Encoder-74LS154 CS fr 74LS377
				asm("nop");																					// !!!! mindestens 4 * NOP
				asm("nop");
				asm("nop");
				asm("nop");
				asm("nop");
				asm("nop");
				PORTD |= _BV(7);																			// MC-Port-D7 = [1___.____] => Encoder-74LS154 kein CS fr 74LS377 ==> Wert im 74LS377 speichern
				}
			// MC und Interface Grundstellung -----------------------------------------------
			PORTD |= _BV(7);																				// MC-Port-D7 = 1 => Encoder-74LS154 nicht aktiv, kein CS
			PORTD |= _BV(3);																				// MC-Port-D3 = 1 => Interface-74LS245 Interface-Daten output
			PORTD |= _BV(4);																				// MC-Port-D4 = 1 => Interface-74LS245 Daten inaktiv
			PORTA = 0x00;																					// MC-Port-D Adresse = [00]
			PORTC = 0x00;																					// MC-Port-C Daten = [00]
			}	
		// Geschwindigkeitsausgabe ENDE ----------------------------------------------------------------------------------------------
/*

		//#############################################################################################################################
		// Kurzschlussmessung auf Strecken-Karten 
		//#############################################################################################################################
		if (Peek == (Fahrstufen_MAX + 1))
			{
			// Test Timer
			}

		//#############################################################################################################################
		// Kurzschlussmessung auf Strecken-Karten 
		//#############################################################################################################################
		if (Peek == (Fahrstufen_MAX + 2))
			{
			//@---------------------------------------------------------------------------------------------------------------------------
			//@ MC und Inteface Output 
			PORTD |= _BV(7);													// MC-SteuerPort-D7 auf 1 => Encoder-74LS154 nicht aktiv, kein CS
			PORTD |= _BV(3);													// MC-SteuerPort-D3 auf 1 => Interface-74LS245 Daten output
			PORTD &= 255-_BV(4);												// MC-SteuerPort-D4 auf 0 => Interface-74LS245 Daten aktiv
			DDRC = 0xFF;														// MC-Port-C output
			//@ alle Daten = Geschwindigkeit = 0
			PORTC = 0xFF;														// MC-DatenPort-C = [00]
			//@---------------------------------------------------------------------------------------------------------------------------
			//@ Adressen-Port-A = [0..34] alle Block- und Strecken-Daten auf 0
			for (Strecken_Karten_Adresse = 0; Strecken_Karten_Adresse < 35; Strecken_Karten_Adresse++)		// Karte - Adressen-Port-A = [0+35..34+35]
				{
				PORTA = Strecken_Karten_Adresse;								// MC-Adressen-Port-A => Adresse des 74LS244 [35..69] ausgeben
				PORTD &= 255-_BV(7);											// MC-SteuerPort-D7 = 0 => Encoder-74LS154 CS fr 74LS377
				asm("nop");														// !!!! mindestens 4 * NOP
				asm("nop");
				asm("nop");
				asm("nop");
				asm("nop");
				asm("nop");
				PORTD |= _BV(7);												// MC-SteuerPort-D7 = [1___.____] => Encoder-74LS154 kein CS fr 74LS377
																				// Wert im 74LS377 gespeichert
				}
			//@---------------------------------------------------------------------------------------------------------------------------
			//@ MC und Inteface Input
			PORTD |= _BV(7);													// MC-D7 auf 1 => 74LS154 Encoder nicht aktiv, kein CS
			DDRC = 0x00; 														// MC-Port-C (Daten) als Eingang 
			PORTC = 0xFF; 														// MC-Port-C (Daten) als Eingang - with pull-ups enabled
			PORTD &= 255-_BV(3);												// MC-D3 auf 0 => 74LS245 Interface-Daten input
			PORTD &= 255-_BV(4);												// MC-D4 auf 0 => 74LS245 Interface-Daten aktiv
			asm("nop");															// !!!! mindestens 4 * NOP
			asm("nop");
			asm("nop");
			asm("nop");
			asm("nop");
			asm("nop");
			//@---------------------------------------------------------------------------------------------------------------------------
			//@ Adressen-Port-A = [35..70] ==> Belegdaten von den Eisenbahnkarte 35 bis 70 einlesen
			for (Strecken_Karten_Adresse = 0; Strecken_Karten_Adresse < 35; Strecken_Karten_Adresse++)	
				{
				PORTA = Strecken_Karten_Adresse + 35;							// MC-AdressenPort-A fr 74LS244 [35..69] ausgeben
				//@ Beleg 74LS244 aktiv
				PORTD &= 255-_BV(7);											// MC-SteuerPort-D7 = 0 => Karten-CS 74LS244 = aktiv
				asm("nop");														// !!!! mindestens 4 * NOP
				asm("nop");
				asm("nop");
				asm("nop");
				asm("nop");
				asm("nop");
				//@ Beleg von Eisenbahn einlesen 
				Kurzschluss_Register[Strecken_Karten_Adresse + 1] = PINC;		// Einlesen von Karten-Adresse [35..69] * 8 Bit => BS-Array
				PORTD |= _BV(7);												// MC-SteuerPort-D7 = 1 => 74LS154 Encoder nicht aktiv
				}
			// Test Timer
			PORTD &= 255-_BV(2);
			}
		// Kurzschlussmessung ENDE ----------------------------------------------------------------------------------------------------	

*/
		//#############################################################################################################################
		// Besetztmessung 
		// alle Blocks und Streckenteile Daten auf NULL
		//#############################################################################################################################
		if (Peek == (Fahrstufen_MAX + 3))
			{
			//@---------------------------------------------------------------------------------------------------------------------------
			//@ MC und Inteface Output 
			PORTD |= _BV(7);													// MC-SteuerPort-D7 auf 1 => Encoder-74LS154 nicht aktiv, kein CS
			PORTD |= _BV(3);													// MC-SteuerPort-D3 auf 1 => Interface-74LS245 Daten output
			PORTD &= 255-_BV(4);												// MC-SteuerPort-D4 auf 0 => Interface-74LS245 Daten aktiv
			DDRC = 0xFF;														// MC-Port-C output
			//@ alle Daten = Geschwindigkeit = 0
			PORTC = 0x00;														// MC-DatenPort-C = [00]
			//@---------------------------------------------------------------------------------------------------------------------------
			//@ Adressen-Port-A = [0..34] alle Block- und Strecken-Daten auf 0
			for (Strecken_Karten_Adresse = 0; Strecken_Karten_Adresse < 35; Strecken_Karten_Adresse++)		// Karte - Adressen-Port-A = [0+35..34+35]
				{
				PORTA = Strecken_Karten_Adresse;								// MC-Adressen-Port-A => Adresse des 74LS244 [35..69] ausgeben
				PORTD &= 255-_BV(7);											// MC-SteuerPort-D7 = 0 => Encoder-74LS154 CS fr 74LS377
				asm("nop");														// !!!! mindestens 4 * NOP
				asm("nop");
				asm("nop");
				asm("nop");
				asm("nop");
				asm("nop");
				PORTD |= _BV(7);												// MC-SteuerPort-D7 = [1___.____] => Encoder-74LS154 kein CS fr 74LS377
																				// Wert im 74LS377 gespeichert
				}
			//@---------------------------------------------------------------------------------------------------------------------------
			//@ MC und Inteface Input
			PORTD |= _BV(7);													// MC-D7 auf 1 => 74LS154 Encoder nicht aktiv, kein CS
			DDRC = 0x00; 														// MC-Port-C (Daten) als Eingang 
			PORTC = 0xFF; 														// MC-Port-C (Daten) als Eingang - with pull-ups enabled
			PORTD &= 255-_BV(3);												// MC-D3 auf 0 => 74LS245 Interface-Daten input
			PORTD &= 255-_BV(4);												// MC-D4 auf 0 => 74LS245 Interface-Daten aktiv
			asm("nop");															// !!!! mindestens 4 * NOP
			asm("nop");
			asm("nop");
			asm("nop");
			asm("nop");
			asm("nop");
			//@---------------------------------------------------------------------------------------------------------------------------
			//@ Adressen-Port-A = [35..70] ==> Belegdaten von den Eisenbahnkarte 35 bis 70 einlesen
			for (Strecken_Karten_Adresse = 0; Strecken_Karten_Adresse < 35; Strecken_Karten_Adresse++)	
				{
				PORTA = Strecken_Karten_Adresse + 35;							// MC-AdressenPort-A fr 74LS244 [35..69] ausgeben
				//@ Beleg 74LS244 aktiv
				PORTD &= 255-_BV(7);											// MC-SteuerPort-D7 = 0 => Karten-CS 74LS244 = aktiv
				asm("nop");														// !!!! mindestens 4 * NOP
				asm("nop");
				asm("nop");
				asm("nop");
				asm("nop");
				asm("nop");
				//@ Beleg von Eisenbahn einlesen 
				Beleg_Register[Strecken_Karten_Adresse + 1] = PINC;				// Einlesen von Karten-Adresse [35..69] * 8 Bit => BS-Array
				PORTD |= _BV(7);												// MC-SteuerPort-D7 = 1 => 74LS154 Encoder nicht aktiv
				}
			}


		//#############################################################################################################################
		// Besetztmessung jetzt weil alle Impulswerte = 0 
		// alle Werte von Block und Streckenteilen eingelesen
		// aufgeteilt in zwei Peeks am 22-12-2018 
		//#############################################################################################################################
		if (Peek == (Fahrstufen_MAX + 4))
			{
			// xxxxxxxxxxxx
			}
		// Besetztmessung ENDE ------------------------------------------------------------------------------------------------

		//#########################################################################################################################
		// StreckenRegister an Platinen ausgeben 
		// es werden die einzelnen Streckenteil-Transistoren geschaltet
		// vom 28.02.2014 
		//#########################################################################################################################
		if (Peek == (Fahrstufen_MAX + 5))
			{
			// MC und Inteface Output -------------------------------------------------------------------------------------------------
			PORTD |= _BV(7);																				// MC-D7 auf 1 => 74LS154 Encoder nicht aktiv
			PORTD |= _BV(3);																				// MC-D3 auf 1 => 74LS245 Interface-Daten output
			PORTD &= 255-_BV(4);																			// MC-D4 auf 0 => 74LS245 Interface-Daten aktiv
			DDRC = 0xFF;																					// MC-Port-C Daten Output
			// Streckenteile aktualisieren ---------------------------------------------------------------------------------------
			for (Strecken_Karten_Adresse = 1; Strecken_Karten_Adresse <= 32; Strecken_Karten_Adresse++)   	// Karten-Nr [4..34] - Regelung ab 01.02.2014
				{
				PORTA = Strecken_Karten_Adresse + 3;	 													// Port-A => Adresse der Karte ausgeben
				asm("nop");
				PORTC = Strecken_Status_Register[Strecken_Karten_Adresse];									// Port-C => Daten ausgeben
				asm("nop");
				
				PORTD &= 255-_BV(7);																		// MC-Steuer-Port-D7 = 0 => 74LS154 Decoder
				asm("nop");																					// !!!! mindestens 4 * NOP
				asm("nop");
				asm("nop");
				asm("nop");
				asm("nop");
				asm("nop");
				PORTD |= _BV(7);																			// MC-Steuer-Port-D => Karten-CS 74LS244 = deaktiv
				}
			// Interface Grundstellung ----------------------------------------------
			PORTD |= _BV(7);																				// MC-D7 auf 1 => 74LS154 Encoder nicht aktiv
			PORTD |= _BV(3);																				// MC-D3 auf 1 => 74LS245 Interface-Daten output
			PORTD |= _BV(4);																				// MC-D4 auf 1 => 74LS245 Interface-Daten inaktiv
			PORTA = 0x00;																					// MC-Port-D Adresse = [00]
			PORTC = 0x00;																					// MC-Port-C Daten = [00]
			
			Peek = 0;  // eine Ausgabe Fahrstufen und einlesen von Kurzschluss und Beleg beendet
			}
		// StreckenRegister an Platinen ausgeben ENDE ---------------------------------------------------------------------------------

		// Test Timer - Auf dem Port D wir eine Bit angechaltet zum Messen der Zeit
		PORTD &= 255-_BV(6);
		}
		// Timer-Routine - Ende ------------------------------------------------------------------------------------------------------

		if((stack_watchdog++) > WTT)  //emergency reset of the stack
			{
			// RESET();  wg. Ansatz Radig
			}
//		eth.timer = 1;  
	}
