/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        24.10.2007
 Description:    RS232 Routinen

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
 GNU General Public License, wie von der Free Software Foundation verffentlicht, 
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
 (nach Ihrer Option) jeder spteren Version. 

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
 Programm erhalten haben. 
 Falls nicht, schreiben Sie an die Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
------------------------------------------------------------------------------*/
#include "config.h"
#include "usart.h"

#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <string.h>
#include <avr/io.h>

	
volatile unsigned int buffercounter = 0;

char usart_rx_buffer[BUFFER_SIZE];
char *rx_buffer_pointer_in	= &usart_rx_buffer[0];
char *rx_buffer_pointer_out	= &usart_rx_buffer[0];
	
//----------------------------------------------------------------------------
//Init serielle Schnittstelle
void usart_init(unsigned long baudrate) 
	{ 
	#if !USE_CAM
	//Serielle Schnittstelle 1
	//Enable TXEN im Register UCR TX-Data Enable
	UCR =(1 << TXEN | 1 << RXEN | 1<< RXCIE);
	// 0 = Parity Mode Disabled
	// 1 = Parity Mode Enabled, Even Parity
	// 2 = Parity Mode Enabled, Odd Parity
	//UCSRC = 0x06 + ((parity+1)<<4);
	//UCSRC |= (1<<USBS);
	//Teiler wird gesetzt 
	UBRR=(F_CPU / (baudrate * 16L) - 1);
	usart_status.usart_disable = 0;
	#endif //USE_CAM
	}

//----------------------------------------------------------------------------
//Routine fr die Serielle Ausgabe eines Zeichens (Schnittstelle0)
void usart_write_char(char c)
	{
	#if CMD_TELNET
	if(usart_status.usart_disable)
		{
		if(rx_buffer_pointer_in == (rx_buffer_pointer_out - 1))
			{
			telnetd_send_data ();							//Datenverlust !
			while(telnetd_status.ack_wait)
				{
				eth_get_data();
				}
			}
		*rx_buffer_pointer_in++ = c;
		if (rx_buffer_pointer_in == &usart_rx_buffer[BUFFER_SIZE-1])
			{
			rx_buffer_pointer_in = &usart_rx_buffer[0];
			}
		}
		return;
	#else
	#if !USE_CAM
	if(!usart_status.usart_disable)
		{
		//Warten solange bis Zeichen gesendet wurde
		while(!(USR & (1<<UDRE)));
		//Ausgabe des Zeichens
		UDR = c;
		}
	return;
	#endif //USE_CAM
	#endif
	}

//------------------------------------------------------------------------------
void usart_write_P (const char *Buffer,...)
	{
	va_list ap;
	va_start (ap, Buffer);	
	
	int format_flag;
	char str_buffer[10];
	char str_null_buffer[10];
	char move = 0;
	char Base = 0;
	int tmp = 0;
	char by;
	char *ptr;
		
	//Ausgabe der Zeichen
	for(;;)
		{
		by = pgm_read_byte(Buffer++);
		if(by == 0) break; 								// end of format string    
		if (by == '%')
			{
			by = pgm_read_byte(Buffer++);
			if (isdigit(by)>0)
				{                    
 				str_null_buffer[0] = by;
				str_null_buffer[1] = '\0';
				move = atoi(str_null_buffer);
				by = pgm_read_byte(Buffer++);
				}
			switch (by)
				{
				case 's':
					ptr = va_arg(ap,char *);
					while(*ptr) 
						{ 
						usart_write_char(*ptr++); 
						}
					break;
				case 'b':
					Base = 2;
					goto ConversionLoop;
				case 'c':
					format_flag = va_arg(ap,int);			//Int to char
					usart_write_char (format_flag++);
					break;
				case 'i':
					Base = 10;
					goto ConversionLoop;
				case 'o':
					Base = 8;
					goto ConversionLoop;
				case 'x':
					Base = 16;
					//****************************
					ConversionLoop:
					//****************************
					itoa(va_arg(ap,int),str_buffer,Base);
					int b=0;
					while (str_buffer[b++] != 0)
						{};
					b--;
					if (b<move)
						{
						move -=b;
						for (tmp = 0;tmp<move;tmp++)
							{
							str_null_buffer[tmp] = '0';
							}
						//tmp ++;
						str_null_buffer[tmp] = '\0';
						strcat(str_null_buffer,str_buffer);
						strcpy(str_buffer,str_null_buffer);
						}
					usart_write_str (str_buffer);
					move =0;
					break;
				}
			}
		else
			{
			usart_write_char ( by );
			}
		}
	va_end(ap);
	}

//----------------------------------------------------------------------------
//Ausgabe eines Strings
void usart_write_str(char *str)
	{
	while (*str)
		{
		usart_write_char(*str++);
		}
	}

//----------------------------------------------------------------------------
//Empfang eines Zeichens
#if !USE_CAM
#if !USE_ARTNET
ISR (USART_RX)																			// A.Fischer => ISR = Interrupt Service Routine
	{
	if(!usart_status.usart_disable)
		{
		unsigned char receive_char;
		receive_char = (UDR);															// A.Fischer => Zeichen aus dem UART-Empfangsregister auslesen
//		#if USART_ECHO																	// A. Walder => in Usart.h
//		usart_write_char(receive_char);
//		#endif
		if (usart_status.usart_ready)													// A.Fischer => Das Flag wird in der Hauptschleife gelscht
			{
			usart_status.usart_rx_ovl = 1;												// A.Fischer => Kommando noch nicht bearbeitet (Overflow)
			return; 																	// A.Fischer => Ausgelesenes Zeichen verwerfen, ISR verlassen
			}     
		if (receive_char == 0x08)														// A.Fischer => Backspace empfangen?
			{
			if (buffercounter) buffercounter--;											// A.Fischer => Letztes Zeichen lschen
				return;																	// A.Fischer => ISR  verlassen
																						// A.Fischer => Die 2. Hlfte der Bedingung (hinter &&) ist fragwrdig und falsch?!
																						// A.Fischer => Was fr eine Sonderfunktion soll die Zeichenfolge "\<CR>" haben?
																						// A.Fischer => Was passiert, wenn buffercounter-1 negativ ist?
			}
		if (receive_char == '\r' && (!(usart_rx_buffer[buffercounter-1] == '\\')))	// A.Fischer => <CR> empfangen?
			{
			usart_rx_buffer[buffercounter] = 0;											// A.Fischer => Gesammelte Zeichen mit 0x00 terminieren
			buffercounter = 0;															// A.Fischer => Einfgestelle fr nchstes Zeichen zurcksetzen
																						// A.Fischer => einer Meinung nach keine gute Idee!!!!!
			usart_status.usart_ready = 1;												// A.Fischer => Hauptschleife informieren und Augen zu.
																						// A.Fischer => Keine weiteren Zeichen mehr sammeln, bis die Hauptschleife dran war!
			return;																		// A.Fischer => ISR verlassen
			}
		if (buffercounter < BUFFER_SIZE - 1)
			{
			usart_rx_buffer[buffercounter++] = receive_char;							// A.Fischer => 	Zeichen sammeln   
			}
		}
	else
		{																				// A.Fischer => Was ist mit diesem Code-Teil? 
																						// A.Fischer => Das soll sowas wie einen Ringpuffer implementieren.
																						// A.Fischer => Die folgende Erkennung eines vollen Puffers ist allerdings falsch!
																						// A.Fischer => Der Sonderfall, das rx_buffer_pointer_out auf usart_rx_buffer[0] zeigt und
																						// A.Fischer => rx_buffer_pointer_in auf usart_rx_buffer[BUFFER_SIZE-2] zeigt, wird nicht erkannt!!!
		if(rx_buffer_pointer_in == (rx_buffer_pointer_out - 1))
			{
			return;																		//Datenverlust
			}																			// A.Fischer => Die folgende Bedingung fr das Rcksetzen des Zeigers an den Anfang
																						// A.Fischer => lsst das letzte Byte im Puffer immer ungenutzt.
		*rx_buffer_pointer_in++ = UDR;													// A.Fischer => Zeichen im Puffer sammeln, Zeiger weiterrcken 
		if (rx_buffer_pointer_in == &usart_rx_buffer[BUFFER_SIZE-1])					// A.Fischer => Ende des Puffers ?
			{
			rx_buffer_pointer_in = &usart_rx_buffer[0];									// A.Fischer => Zeiger zurck an den Anfang 
			}
		}
	return;
	}
#endif //USE_ARTNET
#endif //USE_CAM


